/* 
 * $Id$ 
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.List;

import csbase.client.applications.commandsmonitor.models.ColumnDTO;

import tecgraf.javautils.xml.XMLElement;
import tecgraf.javautils.xml.XMLElementInterface;

/**
 * Elemento coluna do XML
 * @author Tecgraf/PUC-Rio
 */
public class ColumnElement extends XMLElement {

  /**
   * Consulta o nome da tag
   * @return o nome
   */
  public static final String getTagName() {
    return "column";
  }
    
  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {
    String id = getAttributeStrValue("id");
    String className = getAttributeStrValue("class");
    setAppObject(new ColumnDTO(id, className));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }  
}
