/*
 * $Id: ImageViewerSaveAction.java 146656 2013-11-07 17:13:39Z mjulia $
 */
package csbase.client.applications.imageviewer.actions.io;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.ImageViewerIO;
import csbase.client.applications.imageviewer.actions.ImageViewerAction;
import csbase.logic.ClientFile;

/**
 * Ao de salvar o arquivo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ImageViewerSaveAction extends ImageViewerAction {

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public ImageViewerSaveAction(ImageViewer application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    final ImageViewer application = getApplication();
    final BufferedImage image = application.getCurrentBufferedImage();
    final ClientFile currentFile = application.getCurrentFile();
    if (image == null || currentFile == null) {
      return;
    }
    ImageViewerIO.writeTask(application, image, currentFile);
    final String msg = getString("ImageViewerSaveAction.success.msg");
    application.setSaveNeeded(false);
    application.showInformation(msg);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ImageIcon getDefaultIcon() {
    return ApplicationImages.ICON_SAVE_16;
  }
}
