package csbase.client.desktop;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import csbase.client.applications.ApplicationImages;

/**
 * Ao para exibio de about do sistema.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class AboutAction extends DesktopAction<DesktopFrame> {

  /**
   * {@inheritDoc}
   */
  @Override
  final public void actionPerformed(final ActionEvent ae) {
    final DesktopFrame desktop = getDesktop();
    final DesktopComponentFrame frame = desktop.getDesktopFrame();
    final AboutDialog aboutDialog = new AboutDialog(frame);
    aboutDialog.center();
    aboutDialog.setVisible(true);
  }

  /**
   * Construtor
   */
  public AboutAction() {
    super(DesktopFrame.getInstance());
    putValue(Action.SMALL_ICON, ApplicationImages.ICON_ABOUT_16);
    putValue(Action.NAME, getString("name"));
    putValue(Action.SHORT_DESCRIPTION, getString("tooltip"));
  }
}
