package csbase.client.preferences.types;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.editors.PVBooleanEditor;
import csbase.client.preferences.util.PreferenceBundle;

/**
 * Preferncia que encapsula um valor boleano. Este valor deve ser usado da
 * seguinte forma:<br/>
 * 
 * \@Value(type=PVBoolean.class, defaultValue="true")
 * 
 * @see PreferenceValue PreferenceCategory PreferencePolicy
 * 
 * @author Tecgraf
 */
public class PVBoolean extends PreferenceValue<Boolean> {

  /**
   * Construtor usado na instanciao desta classe por reflexo.
   * 
   * @param name nome da preferncia que possui este valor.
   * @param value valor da preferncia.
   * @param defaultValue valor default da preferncia.
   * @param policy poltica de visibilidade do valor.
   * @param preferenceBundle objeto responsvel pela internacionalizao.
   */
  public PVBoolean(PreferenceDefinition name, String value,
    String defaultValue, PreferencePolicy policy,
    PreferenceBundle preferenceBundle) {
    super(name, value, defaultValue, policy, preferenceBundle);

    setPreferenceEditorClass(PVBooleanEditor.class);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClassName() {
    return getClass().getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Boolean toValue(String value) {
    return Boolean.parseBoolean(value);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return getValue().toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PreferenceValue<Boolean> clone() {
    return new PVBoolean(name, this.toString(), defaultValue, policy,
      preferenceBundle);
  }
}
