/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.ProjectsManagerPanel;
import csbase.client.applications.projectsmanager.panels.filters.AbstractProjectFilter;
import csbase.client.applications.projectsmanager.panels.filters.ProjectBasicInfoFilterPanel;
import csbase.client.applications.projectsmanager.panels.filters.ProjectCreationDateFilterPanel;
import csbase.client.applications.projectsmanager.panels.filters.ProjectFileSystemLocationPanel;
import csbase.client.applications.projectsmanager.panels.filters.ProjectModificationDateFilterPanel;
import csbase.client.applications.projectsmanager.panels.filters.ProjectSpaceFilterPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;

public class FilterPanel
extends ProjectsManagerPanel {
    private final ProjectBasicInfoFilterPanel projectBasicInfoFilterPanel;
    private final ProjectCreationDateFilterPanel projectCreationDateFilterPanel;
    private final ProjectModificationDateFilterPanel projectModificationDateFilterPanel;
    private final ProjectSpaceFilterPanel projectSpaceFilterPanel;
    private final ProjectFileSystemLocationPanel projectFileSystemLocationPanel;
    private final KeyListener generalKeyListener;
    private final ItemListener generalItemListener;
    private final Insets insets = new Insets(3, 8, 3, 8);
    private final Insets verticalInsets = new Insets(3, 0, 3, 0);
    private final Insets largeLeftInsets = new Insets(3, 25, 3, 8);
    private final List<AbstractProjectFilter> filters = new ArrayList<AbstractProjectFilter>();

    public FilterPanel(ProjectsManager projectsManager) {
        super(projectsManager);
        this.projectBasicInfoFilterPanel = new ProjectBasicInfoFilterPanel(projectsManager);
        this.projectCreationDateFilterPanel = new ProjectCreationDateFilterPanel(projectsManager);
        this.projectModificationDateFilterPanel = new ProjectModificationDateFilterPanel(projectsManager);
        this.projectSpaceFilterPanel = new ProjectSpaceFilterPanel(projectsManager);
        this.projectFileSystemLocationPanel = new ProjectFileSystemLocationPanel(projectsManager);
        this.filters.add(this.projectBasicInfoFilterPanel);
        this.filters.add(this.projectCreationDateFilterPanel);
        this.filters.add(this.projectModificationDateFilterPanel);
        this.filters.add(this.projectSpaceFilterPanel);
        this.filters.add(this.projectFileSystemLocationPanel);
        this.generalKeyListener = this.createGeneralKeyListener();
        this.generalItemListener = this.createGeneralItemListener();
        this.applyGeneralListener();
        this.buildPanel();
    }

    private void buildPanel() {
        ProjectsManager projectsManager = this.getProjectsManager();
        JPanel panel = projectsManager.hasAreaReserved() ? this.buildPanelWithAllocation() : this.buildPanelWithoutAllocation();
        this.setLayout(new GridBagLayout());
        this.add((Component)panel, new GBC(0, 0).both());
        BorderUtil.setTitledBorder((JComponent)this, (String)this.getString("FilterPanel.project.filter.title"));
        this.validate();
        this.repaint();
    }

    private JPanel buildPanelWithAllocation() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectNameLabel(), new GBC(0, 0).west().insets(this.verticalInsets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectNameField(), new GBC(1, 0).width(2).horizontal().insets(this.insets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectOwnerLabel(), new GBC(3, 0).west().insets(this.largeLeftInsets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectOwnerPanel(), new GBC(4, 0).width(2).horizontal().insets(this.verticalInsets));
        panel.add((Component)this.projectFileSystemLocationPanel.getLabelPanel(), new GBC(0, 1).width(1).west().insets(this.verticalInsets));
        panel.add((Component)this.projectFileSystemLocationPanel.getTextPanel(), new GBC(1, 1).width(2).insets(this.insets).horizontal());
        panel.add((Component)this.projectCreationDateFilterPanel.getMainLabel(), new GBC(0, 2).west().insets(this.verticalInsets));
        panel.add((Component)this.projectCreationDateFilterPanel.getFromPanel(), new GBC(1, 2).horizontal().insets(this.insets));
        panel.add((Component)this.projectCreationDateFilterPanel.getUntilPanel(), new GBC(2, 2).horizontal().insets(this.insets));
        panel.add((Component)this.projectModificationDateFilterPanel.getMainLabel(), new GBC(3, 2).west().insets(this.largeLeftInsets));
        panel.add((Component)this.projectModificationDateFilterPanel.getFromPanel(), new GBC(4, 2).horizontal().insets(this.insets));
        panel.add((Component)this.projectModificationDateFilterPanel.getUntilPanel(), new GBC(5, 2).horizontal().insets(this.insets));
        panel.add((Component)this.projectSpaceFilterPanel.getAllocatedSpaceLabel(), new GBC(0, 3).west().insets(this.verticalInsets));
        panel.add((Component)this.projectSpaceFilterPanel.getAllocatedFromSpacePanel(), new GBC(1, 3).horizontal().insets(this.insets));
        panel.add((Component)this.projectSpaceFilterPanel.getAllocatedUntilSpacePanel(), new GBC(2, 3).horizontal().insets(this.insets));
        panel.add((Component)this.projectSpaceFilterPanel.getOccupiedSpaceLabel(), new GBC(3, 3).west().insets(this.largeLeftInsets));
        panel.add((Component)this.projectSpaceFilterPanel.getOccupiedFromSpacePanel(), new GBC(4, 3).horizontal().insets(this.insets));
        panel.add((Component)this.projectSpaceFilterPanel.getOccupiedUntilSpacePanel(), new GBC(5, 3).horizontal().insets(this.insets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectStatusLabel(), new GBC(0, 4).west().insets(this.verticalInsets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getStatusComboPanel(), new GBC(1, 4).width(2).horizontal().insets(this.verticalInsets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectSharingLabel(), new GBC(3, 4).west().insets(this.largeLeftInsets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getSharingComboPanel(), new GBC(4, 4).width(2).horizontal().insets(this.verticalInsets));
        return panel;
    }

    private JPanel buildPanelWithoutAllocation() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectNameLabel(), new GBC(0, 0).west().insets(this.verticalInsets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectNameField(), new GBC(1, 0).width(2).horizontal().insets(this.insets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectOwnerLabel(), new GBC(3, 0).west().insets(this.largeLeftInsets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectOwnerPanel(), new GBC(4, 0).width(2).horizontal().insets(this.verticalInsets));
        panel.add((Component)this.projectCreationDateFilterPanel.getMainLabel(), new GBC(0, 1).west().insets(this.verticalInsets));
        panel.add((Component)this.projectCreationDateFilterPanel.getFromPanel(), new GBC(1, 1).horizontal().insets(this.insets));
        panel.add((Component)this.projectCreationDateFilterPanel.getUntilPanel(), new GBC(2, 1).horizontal().insets(this.insets));
        panel.add((Component)this.projectModificationDateFilterPanel.getMainLabel(), new GBC(3, 1).west().insets(this.largeLeftInsets));
        panel.add((Component)this.projectModificationDateFilterPanel.getFromPanel(), new GBC(4, 1).horizontal().insets(this.insets));
        panel.add((Component)this.projectModificationDateFilterPanel.getUntilPanel(), new GBC(5, 1).horizontal().insets(this.insets));
        panel.add((Component)this.projectSpaceFilterPanel.getOccupiedSpaceLabel(), new GBC(0, 2).west().insets(this.verticalInsets));
        panel.add((Component)this.projectSpaceFilterPanel.getOccupiedFromSpacePanel(), new GBC(1, 2).horizontal().insets(this.insets));
        panel.add((Component)this.projectSpaceFilterPanel.getOccupiedUntilSpacePanel(), new GBC(2, 2).horizontal().insets(this.insets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getProjectSharingLabel(), new GBC(3, 2).west().insets(this.largeLeftInsets));
        panel.add((Component)this.projectBasicInfoFilterPanel.getSharingComboPanel(), new GBC(4, 2).width(2).horizontal().insets(this.verticalInsets));
        return panel;
    }

    private void runFilters(boolean clearSelection, boolean refresh) {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> allProjects = projectsManager.getAllProjects();
        List<ProjectsManagerData> projects = new ArrayList<ProjectsManagerData>(allProjects);
        for (AbstractProjectFilter filter : this.filters) {
            projects = filter.runFilter(projects, false);
        }
        if (refresh) {
            projectsManager.refreshProjectsTable();
        }
        if (clearSelection) {
            projectsManager.clearProjectSelection();
        }
        projectsManager.clearInfoFields();
    }

    public void runFilters(boolean clearSelection) {
        this.runFilters(clearSelection, true);
    }

    public boolean projectMatchesFilters(ProjectsManagerData prj) {
        for (AbstractProjectFilter filter : this.filters) {
            if (filter.projectMatchesFilter(prj)) continue;
            return false;
        }
        return true;
    }

    private KeyListener createGeneralKeyListener() {
        final FilterPanel fp = this;
        return new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                fp.runFilters(true);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
    }

    private ItemListener createGeneralItemListener() {
        final FilterPanel fp = this;
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                fp.runFilters(true);
            }
        };
    }

    private void applyGeneralListener() {
        this.projectBasicInfoFilterPanel.addListener(this.generalKeyListener);
        this.projectCreationDateFilterPanel.addListener(this.generalKeyListener);
        this.projectModificationDateFilterPanel.addListener(this.generalKeyListener);
        this.projectSpaceFilterPanel.addListener(this.generalKeyListener);
        this.projectFileSystemLocationPanel.addListener(this.generalKeyListener);
        this.projectBasicInfoFilterPanel.addItemListener(this.generalItemListener);
    }

    public void emptyFiltersData() {
        this.projectBasicInfoFilterPanel.emptyFilterData();
        this.projectCreationDateFilterPanel.emptyFilterData();
        this.projectModificationDateFilterPanel.emptyFilterData();
        this.projectFileSystemLocationPanel.emptyFilterData();
        this.projectSpaceFilterPanel.emptyFilterData();
    }
}

