package csbase.client.algorithms.commands.newview;

import java.util.List;

/**
 * Representa a configurao de uma aba de log, com sua identificao, ttulo e
 * arquivos que devem ser visualizados.
 */
class LogTabConfiguration {

  /**
   * Identificador da aba.
   */
  protected String id;

  /**
   * Ttulo da aba.
   */
  protected String title;

  /**
   * Conjunto de padres de nome de arquivo que devem aparecer na aba.
   */
  protected List<String> filePatterns;

  /**
   * Indica se a aba  restrita a apenas os usurios com permisso de acesso.
   */
  protected boolean isRestricted;

  /**
   * Construtor.
   * 
   * @param id O identificador da aba.
   * @param title O ttulo da aba.
   * @param filePatterns O conjunto de padres de nome de arquivo que devem
   *        aparecer na aba.
   * @param isRestricted Indica se a aba  restrita a apenas os usurios com
   *        permisso especfica de acesso.
   */
  public LogTabConfiguration(String id, String title,
    List<String> filePatterns, boolean isRestricted) {
    this.id = id;
    this.title = title;
    this.filePatterns = filePatterns;
    this.isRestricted = isRestricted;
  }

  /**
   * Obtm o conjunto de padres de nome de arquivo que devem aparecer na aba.
   * 
   * @return o conjunto de padres.
   */
  public List<String> getFilePatterns() {
    return filePatterns;
  }

  /**
   * Retorna o ttulo da aba.
   * 
   * @return title O ttulo.
   */
  public String getTitle() {
    return title;
  }

  /**
   * Retorna o identificador da aba.
   * 
   * @return id O identificador.
   */
  public String getId() {
    return id;
  }

  /**
   * Indica se a aba  restrita a apenas os usurios com permisso especfica de
   * acesso.
   * 
   * @return verdadeiro se a aba  restrita ou falso, caso contrrio.
   */
  public boolean isRestricted() {
    return isRestricted;
  }

}
