/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.dialogs.VersionDialog;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractImportFileAction;
import csbase.client.desktop.RemoteTask;
import csbase.client.desktop.Task;
import csbase.client.externalresources.ExternalResources;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.net.URL;
import java.rmi.RemoteException;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ImportDocumentationFile
extends AbstractImportFileAction {
    private final AlgorithmVersionInfo version;

    public ImportDocumentationFile(VersionTree tree, AlgorithmVersionInfo version) {
        super(tree, LNG.get((String)"algomanager.menu.doc.add"), 2, true);
        this.version = version;
    }

    @Override
    protected Task<Boolean> createCheckFileExistenceTask(final String fileName) {
        return new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                AlgorithmInfo algorithm = ImportDocumentationFile.this.version.getInfo();
                this.setResult(ClientRemoteLocator.algorithmService.docFileExists((Object)algorithm.getId(), (Object)ImportDocumentationFile.this.version.getId(), fileName));
            }
        };
    }

    @Override
    protected RemoteFileChannelInfo prepareUpload(String fileName, boolean isZipLocalFile) throws RemoteException {
        AlgorithmInfo algorithm = this.version.getInfo();
        return ClientRemoteLocator.algorithmService.prepareUploadDocFile((Object)algorithm.getId(), (Object)this.version.getId(), fileName, isZipLocalFile);
    }

    @Override
    protected void appletUpload() {
        new UploadDocDialog().uploadDoc();
    }

    private class UploadDocDialog
    extends VersionDialog {
        private Object versionId;

        public UploadDocDialog() {
            super(ImportDocumentationFile.this.version.getInfo());
        }

        public void uploadDoc() {
            String algoId = this.algoInfo.getId();
            if (ExternalResources.getInstance().isEnabled()) {
                String addr = AlgorithmManagementProxy.retrieveDocUploadURL(algoId, this.versionId, ImportDocumentationFile.this.getWindow());
                if (addr == null) {
                    return;
                }
                try {
                    URL url = new URL(addr);
                    ExternalResources.getInstance().showDocument(url);
                }
                catch (Exception ex) {
                    StandardErrorDialogs.showErrorDialog(ImportDocumentationFile.this.getWindow(), this.dialogTitle, LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_IO_ERROR"), ex);
                }
            } else {
                StandardDialogs.showInfoDialog((Component)ImportDocumentationFile.this.getWindow(), (String)this.dialogTitle, (Object)LNG.get((String)"algomanager.error.upload_not_available"));
            }
        }
    }
}

