/*
 * $Id:$
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLElement;
import tecgraf.javautils.xml.XMLElementInterface;
import csbase.client.applications.commandsmonitor.models.CommandsTableDTO;

/**
 * Elemento de conjunto de tabelas.
 * 
 * @author Tecgraf
 */
public class TablesSetElement extends XMLElement {

  /**
   * Consulta o nome da tag
   * 
   * @return tag
   */
  public static final String getTagName() {
    return "tables";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {

    Set<CommandsTableDTO> tablesInfo = new HashSet<CommandsTableDTO>();

    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);
    while (iterator.hasNext()) {
      XMLElementInterface aTableElement = iterator.next();
      CommandsTableDTO aTableInfo =
        (CommandsTableDTO) aTableElement.getAppObject();
      tablesInfo.add(aTableInfo);
    }

    setAppObject(tablesInfo);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }
}
