/**
 * $Id: StatisticalTable.java 152996 2014-05-30 13:26:14Z mjulia $
 */
package csbase.client.applications.serverdiagnostic.statistics;

import java.util.List;

import tecgraf.javautils.gui.table.AbstractColumn;
import tecgraf.javautils.gui.table.ObjectTableBuilder;
import tecgraf.javautils.gui.table.SortableTable;

/**
 * Classe para criar tabelas com dados estatsicos.
 * 
 * @author Tecgraf
 * @param <V> Dado estatstico. Estende {@link StatisticDataEntry}
 */
public class StatisticalTable<V extends StatisticDataEntry<?>> {
  /**
   * Nome da coluna com os nomes das entidades de cada dado estatstico.
   */
  private String entityColumnName;
  /**
   * Noma da coluna com os valores das entidades de cada dado estatstico.
   */
  private String valueColumnName;
  /**
   * Construtor de tabelas.
   */
  private ObjectTableBuilder<V> objectTableBuilder;
  /**
   * Classe do valor do dado estatstico.
   */
  private Class<?> clazz;

  /**
   * Construtor.
   * 
   * @param entityColumnName nome da coluna de entidades
   * @param valueColumnName nome da coluna de valores
   */
  public StatisticalTable(String entityColumnName, String valueColumnName) {
    this.clazz =
      this.getClass().getTypeParameters()[0].getClass().getTypeParameters()[0]
        .getClass();
    this.entityColumnName = entityColumnName;
    this.valueColumnName = valueColumnName;
    this.objectTableBuilder =
      new ObjectTableBuilder<V>(new EntityColumn(), new ValueColumn());
  }

  /**
   * Constri a tabela.
   * 
   * @param data lista de dados estatsticos
   * 
   * @return a tabela
   */
  public SortableTable builtTable(List<V> data) {
    return objectTableBuilder.build(data);
  }

  /**
   * Colula de entidades de dados estatsticos.
   * 
   * @author Tecgraf
   */
  private class EntityColumn extends AbstractColumn<V> {
    /**
     * Construtor
     */
    protected EntityColumn() {
      super(String.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getColumnName() {
      return entityColumnName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Object getValue(V obj) {
      return obj.name;
    }
  }

  /**
   * Colula de valores de dados estatsticos.
   * 
   * @author Tecgraf
   */
  private class ValueColumn extends AbstractColumn<V> {
    /**
     * Construtor
     */
    protected ValueColumn() {
      super(clazz);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getColumnName() {
      return valueColumnName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Object getValue(V obj) {
      return obj.value;
    }
  }
}
