package csbase.client.desktop;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.ApplicationImages;

/**
 * Ao para exibio de dilogo de uso de disco do projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectInfoAction extends AbstractAction {

  /**
   * O desktop da ao.
   */
  final private DesktopFrame desktopFrame;

  /**
   * {@inheritDoc}
   */
  @Override
  final public void actionPerformed(final ActionEvent ae) {
    final ProjectInfoDialog dialog = new ProjectInfoDialog(desktopFrame);
    dialog.center();
    dialog.refresh();
    dialog.setVisible(true);
  }

  /**
   * Construtor
   * 
   * @param desktopFrame o desktop dos sistema.
   */
  public ProjectInfoAction(final DesktopFrame desktopFrame) {
    this.desktopFrame = desktopFrame;
    final String className = ProjectInfoAction.class.getSimpleName();
    final String name = LNG.get(className + ".name");
    putValue(Action.SMALL_ICON, ApplicationImages.ICON_INFORMATION_16);
    putValue(Action.NAME, name);
  }
}
