/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.view;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.algorithms.commands.cache.events.AbstractCommandUpdatedEventListener;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent;
import csbase.client.algorithms.commands.view.CommandViewType;
import csbase.client.algorithms.commands.view.ConsolidatedLogsTab;
import csbase.client.algorithms.commands.view.GetLogTabConfigurationsTask;
import csbase.client.algorithms.commands.view.LogTabConfiguration;
import csbase.client.algorithms.commands.view.Tab;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.kernel.ClientException;
import csbase.client.project.tasks.GetFileTask;
import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.CommonClientProject;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.parameters.FileURLValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.StatusBar;

abstract class AbstractAlgorithmCommandView
extends DesktopComponentFrame {
    private static final long MINIMUN_PREFERRED_HEIGHT = 250L;
    private static final long MINIMUN_PREFERRED_WIDTH = 800L;
    private Tab selected;
    private JTabbedPane tabbedPane;
    private Tab parametersTab;
    private List<Tab> logTabs = new ArrayList<Tab>();
    private AbstractCommandUpdatedEventListener commandListener;
    private CommandInfo command;
    private AlgorithmConfigurator configurator;
    private Integer nodeId;
    private CommandViewType viewType;

    public AbstractAlgorithmCommandView(Object index, DesktopComponentFrame owner, CommandInfo command, AlgorithmConfigurator configurator, CommandViewType viewType, Integer nodeId) throws ClientException {
        super(index, owner, AbstractAlgorithmCommandView.createTitle(command));
        this.command = command;
        this.configurator = configurator;
        this.viewType = viewType;
        this.nodeId = nodeId;
        this.commandListener = this.createCommandListener(command);
        CommandsCache.getInstance().addEventListener(this.commandListener);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (null != AbstractAlgorithmCommandView.this.selected) {
                    AbstractAlgorithmCommandView.this.selected.setSelected(false);
                }
                AbstractAlgorithmCommandView.this.stop();
                AbstractAlgorithmCommandView.removeDesktopComponentFrame(AbstractAlgorithmCommandView.this.getIndex());
            }
        });
        this.initialize(configurator);
        this.initializeGui(configurator);
    }

    protected void initialize(AlgorithmConfigurator cnf) throws ClientException {
    }

    public void show(TabType preferredTab) {
        if (null != preferredTab) {
            Component component = null;
            switch (preferredTab) {
                case LOG: {
                    if (this.logTabs.isEmpty()) break;
                    component = this.logTabs.get(0);
                    break;
                }
                case PARAMETERS: {
                    component = this.parametersTab;
                }
            }
            if (null != component) {
                this.tabbedPane.setSelectedComponent(component);
            }
        }
        this.setVisible(true);
    }

    protected void stop() {
        CommandsCache.getInstance().removeEventListener(this.commandListener);
    }

    @Override
    public void pack() {
        super.pack();
        this.updateSize();
        this.center(this.owner);
        this.updateLocation();
    }

    protected CommandInfo getCommand() {
        return this.command;
    }

    protected void setCommand(CommandInfo command) {
        this.command = command;
        if (command.getStatus() == CommandStatus.FINISHED) {
            this.stop();
        }
    }

    private AbstractCommandUpdatedEventListener createCommandListener(CommandInfo command) {
        return new AbstractCommandUpdatedEventListener(command.getProjectId(), command.getId()){

            @Override
            public void eventFired(CommandUpdatedEvent.Type type, CommandInfo cmd) {
                AbstractAlgorithmCommandView.this.setCommand(cmd);
                AbstractAlgorithmCommandView.this.updateStatusBar();
            }

            @Override
            protected void eventInterrupted(Exception exception, String description) {
                AbstractAlgorithmCommandView.this.getStatusBar().setError(description);
            }
        };
    }

    protected abstract ConfigurationReportTab createConfigurationReportTab(AlgorithmConfigurator var1) throws ClientException;

    private void initializeGui(AlgorithmConfigurator configurator) throws ClientException {
        String title = AbstractAlgorithmCommandView.createTitle(this.command);
        this.setTitle(title);
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = this.createButtonPanel();
        StatusBar statusBar = this.getStatusBar();
        statusBar.showStatusBar();
        JPanel southPane = new JPanel(new BorderLayout());
        southPane.add((Component)buttonPanel, "North");
        southPane.add((Component)statusBar, "South");
        this.add((Component)southPane, "South");
        this.tabbedPane = this.createTabbedPane(configurator);
        this.add((Component)this.tabbedPane, "Center");
        this.updateStatusBar();
        this.pack();
    }

    private static String createTitle(CommandInfo command) {
        Date startDate;
        String title = LNG.get((String)"AbstractAlgorithmCommandView.title");
        String description = command.getDescription();
        if (description != null && description.length() != 0) {
            title = title + " : " + description;
        }
        if ((startDate = command.getSubmittedDate()) != null) {
            title = title + " : " + FormatUtils.format((Date)startDate);
        }
        return title;
    }

    private JTabbedPane createTabbedPane(AlgorithmConfigurator configurator) throws ClientException {
        final JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Tab newSelected = (Tab)tabbedPane.getSelectedComponent();
                if (newSelected.equals(AbstractAlgorithmCommandView.this.selected)) {
                    return;
                }
                if (null != AbstractAlgorithmCommandView.this.selected) {
                    AbstractAlgorithmCommandView.this.selected.setSelected(false);
                }
                AbstractAlgorithmCommandView.this.selected = newSelected;
                newSelected.setSelected(true);
            }
        });
        this.createTabs(tabbedPane, configurator);
        return tabbedPane;
    }

    private void createTabs(JTabbedPane tabbedPane, AlgorithmConfigurator configurator) throws ClientException {
        List<Tab> logsTabs;
        ConfigurationReportTab configurationViewTab = this.createConfigurationReportTab(configurator);
        this.addTab(tabbedPane, configurationViewTab);
        this.parametersTab = configurationViewTab;
        Dimension tabsDimension = new Dimension(600, 300);
        if (this.hasLogsTab() && (logsTabs = this.createLogsTab(tabsDimension)) != null && !logsTabs.isEmpty()) {
            for (Tab tab : logsTabs) {
                this.addTab(tabbedPane, tab);
                this.logTabs.add(tab);
            }
        }
    }

    private List<LogTabConfiguration> getLogTabsConfiguration() {
        GetLogTabConfigurationsTask task;
        String idForLogPattern = null;
        if (this.nodeId != null) {
            idForLogPattern = String.valueOf(this.nodeId);
        }
        if ((task = new GetLogTabConfigurationsTask(this.getCommand(), this.viewType, idForLogPattern)).execute(SwingUtilities.getWindowAncestor(this), this.getTitle(), LNG.get((String)"AbstractAlgorithmCommandView.loading.logs"))) {
            return (List)task.getResult();
        }
        StandardDialogs.showErrorDialog((Component)this.getParent(), (String)this.getTitle(), (String)String.format(LNG.get((String)"AbstractAlgorithmCommandView.loading.logs.error.message"), this.getCommand().getId()));
        return null;
    }

    private void addTab(JTabbedPane tabbedPane, Tab tab) {
        tabbedPane.addTab(tab.getTitle(), tab);
    }

    protected List<Tab> createLogsTab(Dimension preferredSize) {
        List<LogTabConfiguration> configurations = this.getLogTabsConfiguration();
        ArrayList<Tab> logTabs = new ArrayList<Tab>();
        for (LogTabConfiguration conf : configurations) {
            Set<ClientProjectFile> matchingFiles = conf.getFiles();
            String title = conf.getTitle();
            Tab logTab = null;
            logTab = matchingFiles.size() == 1 ? new LogTab(matchingFiles.iterator().next(), title) : new ConsolidatedLogsTab(this.getCommand(), matchingFiles, title);
            logTab.setPreferredSize(preferredSize);
            logTabs.add(logTab);
        }
        return logTabs;
    }

    private JPanel createButtonPanel() {
        JButton closeButton = new JButton(LNG.get((String)"AbstractAlgorithmCommandView.button.close.label"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAlgorithmCommandView.this.close();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    protected void updateStatusBar() {
        StatusBar statusBar = this.getStatusBar();
        switch (this.command.getStatus()) {
            case SCHEDULED: {
                statusBar.setStatus(LNG.get((String)"AbstractAlgorithmCommandView.status.scheduled"));
                break;
            }
            case FINISHED: {
                statusBar.setStatus(this.getFinalizationTypeDescription());
                break;
            }
            case SYSTEM_FAILURE: {
                statusBar.setStatus(LNG.get((String)"AbstractAlgorithmCommandView.status.system_failure"));
                break;
            }
            case EXECUTING: 
            case INIT: 
            case UPLOADING: 
            case DOWNLOADING: {
                if (this.command.isValid()) {
                    if (this.command.isQueued()) {
                        statusBar.setStatus(LNG.get((String)"AbstractAlgorithmCommandView.status.queued"));
                        break;
                    }
                    statusBar.setStatus(LNG.get((String)"AbstractAlgorithmCommandView.status.running"));
                    break;
                }
                statusBar.setStatus(LNG.get((String)"AbstractAlgorithmCommandView.status.disconnected"));
                break;
            }
            default: {
                statusBar.setStatus(LNG.get((String)"AbstractAlgorithmCommandView.status.unknown"));
            }
        }
    }

    protected String getFinalizationTypeDescription() {
        CommandFinalizationInfo finalizationInfo = this.command.getFinalizationInfo();
        CommandFinalizationType finalizationType = finalizationInfo.getFinalizationType();
        if (this.nodeId == null || finalizationInfo.getInfoType() == CommandFinalizationInfo.FinalizationInfoType.SIMPLE) {
            Integer exitCode = finalizationInfo.getExitCode();
            return this.getFinalizationTypeDescription(finalizationType, exitCode);
        }
        ExtendedCommandFinalizationInfo flowfinalizationInfo = (ExtendedCommandFinalizationInfo)finalizationInfo;
        CommandFinalizationInfo nodeFinalizationInfo = flowfinalizationInfo.getFinalizationInfoForNode(this.nodeId.intValue());
        switch (nodeFinalizationInfo.getFinalizationType()) {
            case EXECUTION_ERROR: {
                return this.getFinalizationTypeDescription(CommandFinalizationType.EXECUTION_ERROR, nodeFinalizationInfo.getExitCode());
            }
            case SUCCESS: {
                return this.getFinalizationTypeDescription(CommandFinalizationType.SUCCESS, null);
            }
            case NO_EXIT_CODE: {
                return this.getFinalizationTypeDescription(CommandFinalizationType.NO_EXIT_CODE, null);
            }
        }
        return this.getFinalizationTypeDescription(CommandFinalizationType.END, null);
    }

    protected String getFinalizationTypeDescription(CommandFinalizationType finalizationType, Integer exitCode) {
        switch (finalizationType) {
            case END: {
                return LNG.get((String)"AbstractAlgorithmCommandView.status.finished");
            }
            case EXECUTION_ERROR: {
                if (exitCode != null) {
                    return LNG.get((String)"AbstractAlgorithmCommandView.status.finished.error.code", (Object[])new Object[]{exitCode});
                }
                return LNG.get((String)"AbstractAlgorithmCommandView.status.finished.error");
            }
            case NO_EXIT_CODE: {
                return LNG.get((String)"AbstractAlgorithmCommandView.status.finished.no_code");
            }
            case SUCCESS: {
                return LNG.get((String)"AbstractAlgorithmCommandView.status.finished.success");
            }
            case FAILED: {
                return LNG.get((String)"AbstractAlgorithmCommandView.status.finished.failed");
            }
            case KILLED: {
                return LNG.get((String)"AbstractAlgorithmCommandView.status.finished.killed");
            }
            case LOST: {
                return LNG.get((String)"AbstractAlgorithmCommandView.status.finished.lost");
            }
        }
        return LNG.get((String)"AbstractAlgorithmCommandView.status.finished");
    }

    protected ClientProjectFile getClientProjectFile(FileURLValue fileParameter) {
        if (fileParameter != null) {
            CommonClientProject project = DesktopFrame.getInstance().getProject();
            return GetFileTask.runTask(project, fileParameter.getPathAsArray());
        }
        return null;
    }

    private void updateSize() {
        Dimension screenSize = GUIUtils.getScreenDimension();
        Dimension currentSize = this.getSize();
        double currentWidth = currentSize.getWidth();
        double newWidth = Math.max(currentWidth, 800.0);
        double usuableWidth = screenSize.getWidth();
        newWidth = Math.min(newWidth, usuableWidth);
        double currentHeight = currentSize.getHeight();
        double newHeight = Math.max(currentHeight, 250.0);
        double usuableHeight = screenSize.getHeight();
        newHeight = Math.min(newHeight, usuableHeight);
        Dimension newSize = new Dimension();
        newSize.setSize(newWidth, newHeight);
        this.setSize(newSize);
    }

    private void updateLocation() {
        double newUpperY;
        double newLeftmostX;
        Dimension screenSize = GUIUtils.getScreenDimension();
        Dimension currentSize = this.getSize();
        double usuableWidth = screenSize.getWidth();
        double currentWidth = currentSize.getWidth();
        double usuableHeight = screenSize.getHeight();
        double currentHeight = currentSize.getHeight();
        Point currentLocation = this.getLocation();
        double currentLeftmostX = currentLocation.getX();
        double availableWidth = usuableWidth - currentLeftmostX;
        double currentUpperY = currentLocation.getY();
        double availableHeight = usuableHeight - currentUpperY;
        if (availableWidth < currentWidth) {
            newLeftmostX = currentLeftmostX - (currentWidth - availableWidth);
            newLeftmostX = Math.max(newLeftmostX, 0.0);
        } else {
            newLeftmostX = currentLeftmostX;
        }
        if (availableHeight < currentHeight) {
            newUpperY = currentUpperY - (currentHeight - availableHeight);
            newUpperY = Math.max(newUpperY, 0.0);
        } else {
            newUpperY = currentUpperY;
        }
        Point newLocation = new Point();
        newLocation.setLocation(newLeftmostX, newUpperY);
        this.setLocation(newLocation);
    }

    public AlgorithmConfigurator getConfigurator() {
        return this.configurator;
    }

    private boolean hasLogsTab() {
        ConfigurationManager cnfManager = ConfigurationManager.getInstance();
        boolean defaultValue = false;
        if (cnfManager == null) {
            return false;
        }
        try {
            Class<ConsolidatedLogsTab> propClass = ConsolidatedLogsTab.class;
            Configuration cnf = cnfManager.getConfiguration(propClass);
            String propName = "enabled";
            Boolean isEnabled = cnf.getOptionalBooleanProperty(propName, false);
            return isEnabled;
        }
        catch (Exception e) {
            return false;
        }
    }

    private class LogTab
    extends Tab {
        private final String title;
        private AbstractView view;

        LogTab(ClientProjectFile file, String title) {
            this.setLayout(new GridBagLayout());
            this.title = title;
            if (null == file) {
                this.showOpenLogView(file);
            } else {
                this.showLogPanelView(file);
            }
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public void setSelected(boolean selected) {
            this.view.setSelected(selected);
        }

        public void showLogPanelView(ClientProjectFile file) {
            LogPanelView logPanelView = new LogPanelView(file);
            this.showView(logPanelView, new GBC(0, 0).both());
        }

        public void showOpenLogView(ClientProjectFile file) {
            OpenLogView openLogView = new OpenLogView(file);
            this.showView(openLogView, null);
        }

        private void showView(AbstractView view, Object obj) {
            this.setVisible(false);
            this.removeAll();
            this.add((Component)view, obj);
            this.view = view;
            if (null != AbstractAlgorithmCommandView.this.selected && AbstractAlgorithmCommandView.this.selected.equals(this)) {
                this.view.setSelected(true);
            }
            this.setVisible(true);
        }

        private class OpenLogView
        extends AbstractView {
            OpenLogView(final ClientProjectFile file) {
                class OpenAction
                extends AbstractAction {
                    OpenAction() {
                        super(LNG.get((String)"AbstractAlgorithmCommandView.tab.log.button.reload.label"), ApplicationImages.ICON_REFRESH_24);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (null == file) {
                            String warningMsg = LNG.get((String)"AbstractAlgorithmCommandView.tab.log.file.notFound.dialog");
                            Object[] buttons = new String[]{LogPanel.getString("button.ok", new Object[0])};
                            JOptionPane.showOptionDialog(AbstractAlgorithmCommandView.this.getOwner(), warningMsg, LogTab.this.getTitle(), -1, 2, null, buttons, buttons[0]);
                        } else {
                            LogTab.this.showLogPanelView(file);
                            AbstractAlgorithmCommandView.this.updateStatusBar();
                        }
                    }
                }
                JButton openLogBtn = new JButton(new OpenAction());
                openLogBtn.setToolTipText(LNG.get((String)"AbstractAlgorithmCommandView.tab.log.button.reload.tooltip"));
                this.setLayout(new BorderLayout());
                this.add((Component)openLogBtn, "Center");
            }

            @Override
            public void setSelected(boolean selected) {
                if (selected) {
                    AbstractAlgorithmCommandView.this.getStatusBar().setWarning(LNG.get((String)"AbstractAlgorithmCommandView.tab.log.file.notFound.statusbar"));
                } else {
                    AbstractAlgorithmCommandView.this.updateStatusBar();
                }
            }
        }

        private class LogPanelView
        extends AbstractView {
            private final LogPanel logPanel;
            private final AtomicBoolean wasNeverSelected;
            private final AtomicBoolean wasRunningStatus;
            private final AtomicBoolean ignoreReloaderStatusChangedEvent;

            LogPanelView(final ClientProjectFile file) {
                int pageSizeKb = 100;
                this.logPanel = LogPanel.createLogPanelWithToolBar(6, 100);
                this.logPanel.addThrowableEventListener(new EventListener<LogPanel.ThrowableEvent>(){

                    @Override
                    public void eventFired(LogPanel.ThrowableEvent event) {
                        AbstractAlgorithmCommandView.this.getStatusBar().setError(event.getMessage());
                    }
                });
                this.logPanel.addFileEventListener(new EventListener<LogPanel.FileEvent>(){

                    @Override
                    public void eventFired(LogPanel.FileEvent event) {
                        if (LogPanel.FileEvent.Type.NOT_FOUND == event.getType()) {
                            LogPanelView.this.logPanel.getReloader().stop();
                            LogPanelView.this.logPanel.closeFile();
                            LogTab.this.showOpenLogView(file);
                        }
                        AbstractAlgorithmCommandView.this.updateStatusBar();
                    }
                });
                this.wasNeverSelected = new AtomicBoolean(true);
                this.ignoreReloaderStatusChangedEvent = new AtomicBoolean(false);
                this.wasRunningStatus = new AtomicBoolean(this.logPanel.getReloader().isRunning());
                this.logPanel.getReloader().addStatusChangedEventListener(new EventListener<LogPanelReloader.StatusChangedEvent>(){

                    @Override
                    public void eventFired(LogPanelReloader.StatusChangedEvent event) {
                        if (!LogPanelView.this.ignoreReloaderStatusChangedEvent.compareAndSet(true, false)) {
                            LogPanelView.this.wasRunningStatus.set(event.isRunning());
                        }
                    }
                });
                CommandsCache.getInstance().addEventListener(new AbstractCommandUpdatedEventListener(AbstractAlgorithmCommandView.this.getCommand().getProjectId(), AbstractAlgorithmCommandView.this.getCommand().getId()){

                    @Override
                    protected void eventFired(CommandUpdatedEvent.Type type, CommandInfo command) {
                        switch (type) {
                            case end: 
                            case success: 
                            case error: 
                            case failed: 
                            case killed: 
                            case lost: 
                            case no_code: 
                            case removed: {
                                LogPanelView.this.logPanel.getReloader().stop();
                            }
                        }
                    }
                });
                this.setLayout(new GridBagLayout());
                this.add((Component)this.logPanel, new GBC(0, 0).both());
                this.logPanel.openFile(file);
            }

            @Override
            public void setSelected(boolean selected) {
                boolean ignoreReloader = !this.wasNeverSelected.get();
                if (!(this.wasNeverSelected.compareAndSet(true, !selected) && !AbstractAlgorithmCommandView.this.getCommand().getStatus().equals((Object)CommandStatus.FINISHED) || this.wasRunningStatus.get())) {
                    return;
                }
                this.ignoreReloaderStatusChangedEvent.set(ignoreReloader);
                if (selected) {
                    this.logPanel.getReloader().start();
                } else {
                    this.logPanel.getReloader().stop();
                }
            }
        }

        abstract class AbstractView
        extends JPanel {
            AbstractView() {
            }

            public abstract void setSelected(boolean var1);
        }
    }

    protected abstract class ConfigurationReportTab
    extends Tab {
        protected ConfigurationReportTab() {
        }

        @Override
        protected void setSelected(boolean selected) {
            super.setSelected(selected);
            if (selected) {
                AbstractAlgorithmCommandView.this.updateStatusBar();
            }
        }
    }
}

