/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager;

import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.algorithmsmanager.AlgorithmsManagerAdapter;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmManagementAction;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmsManagerAction;
import csbase.client.applications.algorithmsmanager.actions.CategoryManagementAction;
import csbase.client.applications.algorithmsmanager.actions.ListOutdatedAlgorithmAction;
import csbase.client.applications.algorithmsmanager.actions.ReloadAlgorithmsAction;
import csbase.client.applications.algorithmsmanager.actions.RunTestsAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmsPropertiesDialog;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ShowHistory;
import csbase.client.remote.AlgorithmManagementListener;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import csbase.logic.algorithms.HistoryProvider;
import csbase.logic.algorithms.HistoryRecord;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import tecgraf.javautils.core.lng.LNG;

public class AlgorithmsManager
extends ApplicationProject {
    private static final Dimension DEFAULT_MAIN_FRAME_SIZE = new Dimension(1024, 768);
    private JPanel mainPanel;
    private CategoryManagementAction categoryManagementAction;
    private AlgorithmManagementAction algorithmManagementAction;
    private ReloadAlgorithmsAction reloadAlgorithmsAction;
    private ListOutdatedAlgorithmAction listOutdatedAction;
    private RunTestsAction runTestsAction;
    private JToggleButton categoryToggleButton;
    private JToggleButton algorithmToggleButton;
    private List<AlgorithmsManagerAdapter> algoManagertList = new Vector<AlgorithmsManagerAdapter>();

    public AlgorithmsManager(String id) {
        super(id);
        this.addAlgorithmProxyListener();
        this.buildFrame();
        this.initApplicationAction();
    }

    public void addAlgorithmsManagerListener(AlgorithmsManagerAdapter listener) {
        if (!this.algoManagertList.contains(listener)) {
            this.algoManagertList.add(listener);
        }
    }

    public void removeAlgorithmsManagerListener(AlgorithmsManagerAdapter listener) {
        this.algoManagertList.remove(listener);
    }

    private void addAlgorithmProxyListener() {
        AlgorithmManagementProxy.addManagementListener(new AlgorithmManagementListener(){

            @Override
            public void categoryUpdated(CategorySet modifiedCategorySet) {
                AlgorithmsManager.this.notifyCategoryUpdated(modifiedCategorySet);
            }

            @Override
            public void categoryRemoved(Category category) {
                AlgorithmsManager.this.notifyCategoryRemoved(category);
            }

            @Override
            public void categoryCreated(Category category) {
                AlgorithmsManager.this.notifyCategoryCreated(category);
            }

            @Override
            public void algorithmCreated(AlgorithmInfo algoInfo) {
                AlgorithmsManager.this.notifyAlgorithmCreated(algoInfo);
            }

            @Override
            public void algorithmRemoved(AlgorithmInfo algoInfo) {
                AlgorithmsManager.this.notifyAlgorithmRemoved(algoInfo);
            }

            @Override
            public void algorithmUpdated(AlgorithmInfo algoInfo) {
                AlgorithmsManager.this.notifyAlgorithmUpdated(algoInfo);
            }

            @Override
            public void algorithmsReloaded() {
                AlgorithmsManager.this.refreshApplication();
            }
        });
    }

    private void notifyCategoryCreated(Category category) {
        for (AlgorithmsManagerAdapter listener : this.algoManagertList) {
            listener.categoryCreated(category);
        }
    }

    private void notifyCategoryRemoved(Category category) {
        for (AlgorithmsManagerAdapter listener : this.algoManagertList) {
            listener.categoryRemoved(category);
        }
    }

    private void notifyCategoryUpdated(CategorySet modifiedCategorySet) {
        for (AlgorithmsManagerAdapter listener : this.algoManagertList) {
            listener.categoryUpdated(modifiedCategorySet);
        }
    }

    private void notifyAlgorithmCreated(AlgorithmInfo algoInfo) {
        for (AlgorithmsManagerAdapter listener : this.algoManagertList) {
            listener.algorithmCreated(algoInfo);
        }
    }

    private void notifyAlgorithmRemoved(AlgorithmInfo algoInfo) {
        for (AlgorithmsManagerAdapter listener : this.algoManagertList) {
            listener.algorithmRemoved(algoInfo);
        }
    }

    private void notifyAlgorithmUpdated(AlgorithmInfo algoInfo) {
        for (AlgorithmsManagerAdapter listener : this.algoManagertList) {
            listener.algorithmUpdated(algoInfo);
        }
    }

    private void initApplicationAction() {
        if (this.categoryToggleButton.isSelected()) {
            this.getCategoryManagementAction().initAction();
        } else {
            AlgorithmManagementAction algorithmAction = this.getAlgorithmManagementAction();
            algorithmAction.initAction();
            this.getListOutdatedAction().setSelectionPanel(algorithmAction.getSelectionPanel());
        }
    }

    private void buildFrame() {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        mainFrame.setJMenuBar(this.buildMenuBar());
        mainFrame.getContentPane().add((Component)this.buildToolBar(), "North");
        mainFrame.getContentPane().add(this.getMainPanel());
        mainFrame.showStatusBar();
        mainFrame.setSize(DEFAULT_MAIN_FRAME_SIZE);
        mainFrame.setLocationRelativeTo(null);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
        }
        return this.mainPanel;
    }

    public Dimension getMainPanelSize() {
        return this.getMainPanel().getSize();
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildAdminMenu());
        menuBar.add(this.buildRepositoryMenu());
        return menuBar;
    }

    private JMenu buildAdminMenu() {
        JMenu adminMenu = new JMenu(this.getString("AlgorithmsManager.menu.admin"));
        adminMenu.add(new JMenuItem(this.getAlgorithmManagementAction()));
        adminMenu.add(new JMenuItem(this.getCategoryManagementAction()));
        adminMenu.addSeparator();
        adminMenu.add(new JMenuItem(this.getReloadAlgorithmsAction()));
        adminMenu.add(new JMenuItem(this.getListOutdatedAction()));
        adminMenu.add(new JMenuItem(this.getRunTestsAction()));
        adminMenu.addSeparator();
        adminMenu.add(new ApplicationExitAction(this));
        return adminMenu;
    }

    private JMenu buildRepositoryMenu() {
        JMenu repositoryMenu = new JMenu(this.getString("AlgorithmsManager.menu.repository"));
        repositoryMenu.add(new JMenuItem(new ShowHistory(this.getApplicationFrame(), new RepositoryHistory())));
        JMenuItem algoPropsMenuItem = repositoryMenu.add(this.getString("AlgorithmsManager.menu.repository.properties"));
        algoPropsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmsPropertiesDialog algoPropDialog = AlgorithmsPropertiesDialog.getFrame(AlgorithmsManager.this);
                algoPropDialog.setVisible(true);
            }
        });
        repositoryMenu.add(algoPropsMenuItem);
        return repositoryMenu;
    }

    private JComponent buildToolBar() {
        JToolBar toolBar = new JToolBar();
        ButtonGroup manageGroup = new ButtonGroup();
        this.categoryToggleButton = this.getToggleButton(manageGroup, this.getCategoryManagementAction(), false);
        this.algorithmToggleButton = this.getToggleButton(manageGroup, this.getAlgorithmManagementAction(), true);
        toolBar.add(this.algorithmToggleButton);
        toolBar.add(this.categoryToggleButton);
        toolBar.addSeparator();
        toolBar.add(this.getReloadAlgorithmsAction());
        return toolBar;
    }

    public CategoryManagementAction getCategoryManagementAction() {
        if (this.categoryManagementAction == null) {
            this.categoryManagementAction = new CategoryManagementAction(this, ApplicationImages.ICON_ALGORITHM_CATEGORY_16);
            this.categoryManagementAction.setEnabled(true);
        }
        return this.categoryManagementAction;
    }

    public AlgorithmManagementAction getAlgorithmManagementAction() {
        if (this.algorithmManagementAction == null) {
            this.algorithmManagementAction = new AlgorithmManagementAction(this, ApplicationImages.ICON_ALGORITHM_MNG_16);
            this.algorithmManagementAction.setEnabled(true);
        }
        return this.algorithmManagementAction;
    }

    public ReloadAlgorithmsAction getReloadAlgorithmsAction() {
        if (this.reloadAlgorithmsAction == null) {
            this.reloadAlgorithmsAction = new ReloadAlgorithmsAction(this);
            this.reloadAlgorithmsAction.setEnabled(true);
        }
        return this.reloadAlgorithmsAction;
    }

    public ListOutdatedAlgorithmAction getListOutdatedAction() {
        if (this.listOutdatedAction == null) {
            this.listOutdatedAction = new ListOutdatedAlgorithmAction(this, null);
            this.listOutdatedAction.setEnabled(true);
        }
        return this.listOutdatedAction;
    }

    public RunTestsAction getRunTestsAction() {
        if (this.runTestsAction == null) {
            this.runTestsAction = new RunTestsAction(this);
            this.runTestsAction.setEnabled(true);
        }
        return this.runTestsAction;
    }

    private JToggleButton getToggleButton(ButtonGroup manageGroup, AlgorithmsManagerAction action, boolean setSelected) {
        JToggleButton button = new JToggleButton(action);
        button.setText(null);
        button.setSelected(setSelected);
        manageGroup.add(button);
        return button;
    }

    public void changeMainPanel(JPanel panel) {
        this.mainPanel.removeAll();
        if (panel != null) {
            this.mainPanel.add(panel);
        }
        this.mainPanel.revalidate();
        this.getApplicationFrame().repaint();
    }

    @Override
    public void killApplication() {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        ((Window)mainFrame).dispose();
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    private void rebuildManagementActions() {
        this.getAlgorithmManagementAction().updateToReload();
        this.getCategoryManagementAction().updateToReload();
        this.getListOutdatedAction().updateToReload();
    }

    public SortedSet<Category> getAllCategories(boolean includeSubCategories) {
        SortedSet categories = null;
        CategorySet categorySet = AlgorithmManagementProxy.getAllCategories(this.getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.ADMIN_ALGORITHM);
        if (categorySet != null) {
            categories = includeSubCategories ? categorySet.getAllCategories() : categorySet.getCategories();
        }
        return categories;
    }

    public SortedSet<AlgorithmInfo> getAllAgorithms() {
        AlgorithmInfo[] algorithmInfos = AlgorithmManagementProxy.getAllAlgorithmInfos(this.getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.ADMIN_ALGORITHM);
        TreeSet<AlgorithmInfo> algorithmsSet = new TreeSet<AlgorithmInfo>();
        for (AlgorithmInfo algorithmInfo : algorithmInfos) {
            algorithmsSet.add(algorithmInfo);
        }
        return algorithmsSet;
    }

    public boolean containsAlgorithm(String algoName) {
        SortedSet<AlgorithmInfo> allAgorithms = this.getAllAgorithms();
        for (AlgorithmInfo algo : allAgorithms) {
            if (!algo.getName().trim().toLowerCase().equals(algoName.trim().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAlgorithmWithId(String algoId) {
        SortedSet<AlgorithmInfo> allAgorithms = this.getAllAgorithms();
        for (AlgorithmInfo algo : allAgorithms) {
            if (!algo.getId().equals(algoId)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCategory(String categoryName) {
        SortedSet<Category> categories = this.getAllCategories(false);
        for (Category category : categories) {
            if (!category.getName().trim().toLowerCase().equals(categoryName.trim().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void reloadAlgorithmsFromServer() {
        AlgorithmManagementProxy.reloadAlgorithms(this.getApplicationFrame());
        this.refreshApplication();
    }

    private void refreshApplication() {
        this.algoManagertList.clear();
        this.rebuildManagementActions();
        this.initApplicationAction();
    }

    private class RepositoryHistory
    implements HistoryProvider {
        private RepositoryHistory() {
        }

        public List<HistoryRecord> getHistory() {
            String repositoryName = LNG.get((String)"algomanager.tree.root");
            String[] spath = new String[]{repositoryName};
            return AlgorithmManagementProxy.retrieveHistory(spath);
        }

        public String getName() {
            String repositoryName = LNG.get((String)"algomanager.tree.root");
            return repositoryName;
        }
    }
}

