/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.AlgorithmTreeNode;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.Icon;
import tecgraf.javautils.gui.tree.DefaultNode;

public final class CategoryTreeNode
extends DefaultNode
implements Comparable<CategoryTreeNode> {
    private final Category category;

    public CategoryTreeNode(Category category, boolean showVersions) {
        super(category.getName());
        this.category = category;
        ArrayList<CategoryTreeNode> categoryTreeNodes = new ArrayList<CategoryTreeNode>();
        for (Category childCategory : category.getCategories()) {
            categoryTreeNodes.add(new CategoryTreeNode(childCategory, showVersions));
        }
        Collections.sort(categoryTreeNodes);
        ArrayList<AlgorithmTreeNode> algorithmTreeNodes = new ArrayList<AlgorithmTreeNode>();
        for (AlgorithmInfo algorithm : category.getAlgorithms()) {
            if ("sim".equals(algorithm.getPropertyValue("ocultar"))) continue;
            AlgorithmTreeNode algorithmTreeNode = new AlgorithmTreeNode(algorithm, showVersions);
            algorithmTreeNodes.add(algorithmTreeNode);
        }
        Collections.sort(algorithmTreeNodes);
        LinkedList<DefaultNode> children = new LinkedList<DefaultNode>();
        children.addAll(categoryTreeNodes);
        children.addAll(algorithmTreeNodes);
        for (DefaultNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public int compareTo(CategoryTreeNode node) {
        return this.getCategory().compareTo(node.getCategory());
    }

    public Category getCategory() {
        return this.category;
    }

    public Icon getIcon() {
        if (this.category.getId().equals("-1")) {
            return ApplicationImages.ICON_FAVORITE_16;
        }
        return ApplicationImages.ICON_FOLDER_16;
    }
}

