/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.algorithms.AlgorithmConfiguratorFactory;
import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.applications.flowapplication.FlowTransferable;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphElementListener;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphListener;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.Grid;
import csbase.client.applications.flowapplication.messages.PasteMessage;
import csbase.client.applications.flowapplication.messages.PickGraphMessage;
import csbase.client.applications.flowapplication.messages.RemoveElementsMessage;
import csbase.client.applications.flowapplication.messages.ResetMessage;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.LinkParameter;
import csbase.logic.algorithms.flows.NodeParameter;
import csbase.logic.algorithms.flows.Point;
import csbase.logic.algorithms.parameters.AbstractFileParameter;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.remote.ClientRemoteLocator;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import tecgraf.vix.Group;
import tecgraf.vix.TypeMessage;
import tecgraf.vix.TypeVO;

public final class Graph
extends Group
implements GraphElementListener,
ViewValidator {
    static final int NODE_INSET = 24;
    protected static final java.awt.Point INITIAL_POINT = new java.awt.Point(100, 50);
    private final List<GraphListener> graphListenerList;
    private final Window window;
    private String flowName;
    private String flowDescription;
    private boolean versionInfoVisible;

    public Graph(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("O par\u00e2metro window est\u00e1 nulo.");
        }
        this.graphListenerList = new ArrayList<GraphListener>();
        this.window = window;
        this.versionInfoVisible = false;
    }

    public Graph(Window window, Flow flow) throws ParseException, RemoteException {
        this(window);
        this.flowName = flow.getName();
        this.flowDescription = flow.getDescription();
        this.createGraphNodes(flow);
        this.createGraphLinks(flow);
    }

    public void addGraphListener(GraphListener listener) {
        this.graphListenerList.add(listener);
    }

    public void addGraphListeners(List<GraphListener> listenerList) {
        this.graphListenerList.addAll(listenerList);
    }

    public void clearGraphListeners() {
        this.graphListenerList.clear();
    }

    public GraphLink createGraphLink(int desiredId, GraphFileDescriptor inputFileDescriptor, GraphFileDescriptor outputFileDescriptor, List<Point2D> pointList) {
        GraphLink link = new GraphLink(this, this.generateId(desiredId));
        link.attach();
        if (outputFileDescriptor != null) {
            link.increase(new Point2D.Double());
            link.setStart(outputFileDescriptor);
        }
        for (Point2D point : pointList) {
            link.increase(point);
        }
        if (inputFileDescriptor != null) {
            link.increase(new Point2D.Double());
            link.setEnd(inputFileDescriptor);
        }
        return link;
    }

    public GraphLink createGraphLink(GraphFileDescriptor inputFileDescriptor, GraphFileDescriptor outputFileDescriptor, List<Point2D> pointList) {
        return this.createGraphLink(this.generateId(null), inputFileDescriptor, outputFileDescriptor, pointList);
    }

    private int generateId(Integer desiredId) {
        int id = desiredId != null ? desiredId : 0;
        while (!this.isIdAvailable(id)) {
            ++id;
        }
        return id;
    }

    public GraphNode createGraphNode(AlgorithmConfiguratorView algorithmConfiguratorView, Point2D point, boolean bypassed) {
        GraphNode node = new GraphNode(this, this.generateId(null), algorithmConfiguratorView, point, bypassed, this.versionInfoVisible);
        node.attach();
        return node;
    }

    public GraphNode createGraphNode(AlgorithmConfiguratorView algorithmConfiguratorView, Point2D point, Dimension2D size, boolean bypassed) {
        GraphNode node = new GraphNode(this, this.generateId(null), algorithmConfiguratorView, point, size, bypassed, this.versionInfoVisible);
        node.attach();
        return node;
    }

    public GraphNode createGraphNode(int desiredId, AlgorithmConfiguratorView configuratorView, Point2D point, Dimension2D size, boolean bypassed) {
        GraphNode node = new GraphNode(this, this.generateId(desiredId), configuratorView, point, size, bypassed, this.versionInfoVisible);
        node.attach();
        return node;
    }

    public GraphNode createGraphNode(int desiredId, AlgorithmInfo algorithmInfo, AlgorithmVersionId versionId, Point2D point, Dimension2D size, boolean bypassed) {
        GraphNode node = new GraphNode(this, this.generateId(desiredId), algorithmInfo, versionId, point, size, bypassed, this.versionInfoVisible);
        node.attach();
        return node;
    }

    public GraphNode createGraphNode(int desiredId, String algorithmName, AlgorithmVersionId versionId, Point2D point, Dimension2D size, boolean bypassed) {
        GraphNode node = new GraphNode(this, this.generateId(desiredId), algorithmName, versionId, point, size, bypassed, this.versionInfoVisible);
        node.attach();
        return node;
    }

    public Rectangle2D getBounds2D() {
        if (this.getVOs().isEmpty()) {
            return null;
        }
        TypeVO typeVO = (TypeVO)this.getVOs().get(0);
        Rectangle2D bounds = (Rectangle2D)typeVO.getBounds2D().clone();
        for (int i = 1; i < this.getVOs().size(); ++i) {
            typeVO = (TypeVO)this.getVOs().get(i);
            bounds = bounds.createUnion(typeVO.getBounds2D());
        }
        bounds = Grid.includeMargin(bounds);
        return bounds;
    }

    public Collection<GraphElement> getElementCollection() {
        return Collections.unmodifiableCollection(this.getVOs());
    }

    public Collection<GraphElement> getElementCollection(Point2D pt) {
        LinkedList<GraphElement> elementCollection = new LinkedList<GraphElement>();
        for (GraphElement element : this.getVOs()) {
            if (!element.contains(pt)) continue;
            elementCollection.add(element);
        }
        return elementCollection;
    }

    public Collection<GraphElement> getElementCollection(Rectangle2D bounds) {
        LinkedList<GraphElement> elementCollection = new LinkedList<GraphElement>();
        for (GraphElement element : this.getVOs()) {
            if (!bounds.contains(element.getBounds2D())) continue;
            elementCollection.add(element);
        }
        return elementCollection;
    }

    public Graphics2D getGraphics2D() {
        if (this.getVS() == null) {
            return null;
        }
        return this.getVS().getGraphics2D();
    }

    public List<GraphListener> getGraphListenerList() {
        return Collections.unmodifiableList(this.graphListenerList);
    }

    public GraphLink getLink(int id) {
        for (GraphLink link : this.getLinkCollection()) {
            if (link.getId() != id) continue;
            return link;
        }
        return null;
    }

    public Collection<GraphLink> getLinkCollection() {
        LinkedList<GraphLink> linkCollection = new LinkedList<GraphLink>();
        for (GraphElement element : this.getVOs()) {
            if (!(element instanceof GraphLink)) continue;
            GraphLink graphLink = (GraphLink)element;
            linkCollection.add(graphLink);
        }
        return linkCollection;
    }

    public String getName() {
        return this.flowName;
    }

    public String getDescription() {
        return this.flowDescription;
    }

    public GraphNode getNode(int id) {
        Collection<GraphNode> nodeCollection = this.getNodeCollection();
        for (GraphNode node : nodeCollection) {
            if (node.getId() != id) continue;
            return node;
        }
        return null;
    }

    public GraphNode getNode(String nodeName, AlgorithmVersionId nodeVersionId) {
        Collection<GraphNode> nodeCollection = this.getNodeCollection();
        for (GraphNode node : nodeCollection) {
            if (!node.getAlgorithmName().equals(nodeName) || !node.getAlgorithmVersionId().equals((Object)nodeVersionId)) continue;
            return node;
        }
        return null;
    }

    public Collection<GraphNode> getNodeCollection() {
        LinkedList<GraphNode> nodeCollection = new LinkedList<GraphNode>();
        for (GraphElement obj : this.getVOs()) {
            if (!(obj instanceof GraphNode)) continue;
            GraphNode node = (GraphNode)obj;
            nodeCollection.add(node);
        }
        return nodeCollection;
    }

    public Window getParentWindow() {
        return this.window;
    }

    public Set<GraphElement> getSelectedElements() {
        return this.getSelectedElements(this.getVOs());
    }

    public Set<GraphNode> getSelectedNodes() {
        return this.getSelectedElements(this.getNodeCollection());
    }

    public Set<GraphLink> getSelectedLinks() {
        return this.getSelectedElements(this.getLinkCollection());
    }

    private <T extends GraphElement> Set<T> getSelectedElements(Collection<T> elements) {
        HashSet<GraphElement> selectedElements = new HashSet<GraphElement>();
        for (GraphElement element : elements) {
            if (!element.isSelected()) continue;
            selectedElements.add(element);
        }
        return Collections.unmodifiableSet(selectedElements);
    }

    public List<GraphElement> getVOs() {
        return super.getVOs();
    }

    public boolean hasElements() {
        return !this.getVOs().isEmpty();
    }

    public boolean hasSelectedElements() {
        for (GraphElement element : this.getVOs()) {
            if (!element.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean isExecutable() {
        if (this.getVOs().isEmpty()) {
            return false;
        }
        for (GraphLink link : this.getLinkCollection()) {
            if (link.isWellFormed()) continue;
            return false;
        }
        for (GraphNode node : this.getNodeCollection()) {
            if (node.isWellFormed()) continue;
            return false;
        }
        return true;
    }

    public boolean isReadyToExecute() {
        if (!this.isExecutable()) {
            return false;
        }
        for (GraphElement element : this.getVOs()) {
            GraphNode node;
            if (!(element instanceof GraphNode) || (node = (GraphNode)element).isReadyToExecute()) continue;
            return false;
        }
        return true;
    }

    public Collection<GraphElement> merge(Graph graph) {
        int desiredId;
        if (graph == null) {
            throw new IllegalArgumentException("O par\u00e2metro graph est\u00e1 nulo.");
        }
        LinkedList<GraphElement> elements = new LinkedList<GraphElement>();
        HashMap<GraphFileDescriptor, GraphFileDescriptor> graphFileDescriptors = new HashMap<GraphFileDescriptor, GraphFileDescriptor>();
        for (GraphNode node : graph.getNodeCollection()) {
            GraphFileDescriptor newFileDescriptor;
            desiredId = node.getId();
            AlgorithmConfiguratorView algorithmConfiguratorView = node.getAlgorithmConfiguratorView();
            Point2D.Double nodePoint = new Point2D.Double(node.getX(), node.getY());
            Dimension nodeSize = new Dimension();
            nodeSize.setSize(node.getWidth(), node.getHeight());
            boolean bypassed = node.isBypassed();
            GraphNode newNode = node.isWellFormed() ? this.createGraphNode(desiredId, algorithmConfiguratorView, nodePoint, nodeSize, bypassed) : (node.getAlgorithm() != null ? this.createGraphNode(desiredId, node.getAlgorithm(), node.getAlgorithmVersionId(), (Point2D)nodePoint, (Dimension2D)nodeSize, bypassed) : this.createGraphNode(desiredId, node.getAlgorithmName(), node.getAlgorithmVersionId(), (Point2D)nodePoint, (Dimension2D)nodeSize, bypassed));
            for (GraphFileDescriptor fileDescriptor : node.getInputFileDescriptorCollection()) {
                newFileDescriptor = newNode.getInputFileDescriptor(fileDescriptor.getParameterName());
                if (newFileDescriptor == null) {
                    newFileDescriptor = new GraphFileDescriptor(fileDescriptor.getParameterName(), fileDescriptor.getParameterLabel(), false, newNode);
                    newNode.addInputFileDescriptor(newFileDescriptor);
                }
                graphFileDescriptors.put(fileDescriptor, newFileDescriptor);
            }
            for (GraphFileDescriptor fileDescriptor : node.getOutputFileDescriptorCollection()) {
                newFileDescriptor = newNode.getOutputFileDescriptor(fileDescriptor.getParameterName());
                if (newFileDescriptor == null) {
                    newFileDescriptor = new GraphFileDescriptor(fileDescriptor.getParameterName(), fileDescriptor.getParameterLabel(), true, newNode);
                    newNode.addOutputFileDescriptor(newFileDescriptor);
                }
                graphFileDescriptors.put(fileDescriptor, newFileDescriptor);
            }
            try {
                HashMap<String, String> parameterValuesByName = new HashMap<String, String>();
                for (String parameterName : node.getParameterNames()) {
                    String parameterLabel = node.getParameterLabel(parameterName);
                    String parameterType = node.getParameterType(parameterName);
                    String parameterValue = node.getParameterValue(parameterName);
                    newNode.addParameter(parameterName, parameterLabel, parameterType);
                    parameterValuesByName.put(parameterName, parameterValue);
                }
                newNode.setParameterValuesByName(Collections.unmodifiableMap(parameterValuesByName));
            }
            catch (ParseException | ParameterNotFoundException e1) {
                throw new IllegalStateException(e1.getLocalizedMessage(), e1);
            }
            elements.add(newNode);
        }
        for (GraphLink link : graph.getLinkCollection()) {
            desiredId = link.getId();
            GraphFileDescriptor inputFileDescriptor = (GraphFileDescriptor)((Object)graphFileDescriptors.get((Object)link.getInputFileDescriptor()));
            GraphFileDescriptor outputFileDescriptor = (GraphFileDescriptor)((Object)graphFileDescriptors.get((Object)link.getOutputFileDescriptor()));
            List<Point2D> pointList = link.getPointList();
            ArrayList<Point2D> points = new ArrayList<Point2D>(pointList);
            if (inputFileDescriptor != null) {
                points.remove(points.size() - 1);
            }
            if (outputFileDescriptor != null) {
                points.remove(0);
            }
            this.createGraphLink(desiredId, inputFileDescriptor, outputFileDescriptor, points);
            GraphLink newLink = this.getLink(desiredId);
            elements.add(newLink);
        }
        return elements;
    }

    public boolean msgHandlerVO(TypeMessage msg) {
        if (msg instanceof ResetMessage) {
            this.handleResetMessage();
            return true;
        }
        if (msg instanceof RemoveElementsMessage) {
            return this.handleRemoveElementsMessage();
        }
        if (msg instanceof PickGraphMessage) {
            this.handlePickGraphMessage((PickGraphMessage)msg);
            return true;
        }
        if (msg instanceof PasteMessage) {
            this.handlePasteMessage((PasteMessage)msg);
            return true;
        }
        return super.msgHandlerVO(msg);
    }

    public void notifyChangedWorkspace() {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasChangedWorkspace(this);
        }
    }

    public void removeAllListeners() {
        this.graphListenerList.clear();
        Iterator<GraphElement> i$ = this.getElementCollection().iterator();
        while (i$.hasNext()) {
            GraphElement obj;
            GraphElement element = obj = i$.next();
            element.removeAllListeners();
        }
    }

    public void removeGraphListener(GraphListener listener) {
        this.graphListenerList.remove(listener);
    }

    public void repaint() {
        if (this.getVS() != null) {
            super.repaint();
        }
    }

    public Flow toFlow() {
        return Graph.toFlow(this.flowName, this.flowDescription, this.getNodeCollection(), this.getLinkCollection());
    }

    public static Flow toFlow(String flowName, String flowDescription, Collection<GraphNode> nodes, Collection<GraphLink> links) {
        HashSet<FlowNode> flowNodes = new HashSet<FlowNode>();
        for (GraphNode graphNode : nodes) {
            HashSet<NodeParameter> flowNodeParameters = new HashSet<NodeParameter>();
            for (String parameterName : graphNode.getParameterNames()) {
                try {
                    String parameterLabel = graphNode.getParameterLabel(parameterName);
                    String parameterType = graphNode.getParameterType(parameterName);
                    String parameterValue = graphNode.getParameterValue(parameterName);
                    flowNodeParameters.add(new NodeParameter(parameterName, parameterLabel, parameterType, parameterValue));
                }
                catch (ParameterNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            FlowNode flowNode = graphNode.getAlgorithmConfiguratorView() == null ? new FlowNode(graphNode.getId(), graphNode.getAlgorithmName(), graphNode.getAlgorithmVersionId(), flowNodeParameters, (int)Math.round(graphNode.getX()), (int)Math.round(graphNode.getY()), (int)Math.round(graphNode.getWidth()), (int)Math.round(graphNode.getHeight()), graphNode.isBypassed(), graphNode.hasExitCode()) : new FlowNode(graphNode.getId(), graphNode.getAlgorithmConfiguratorView().getConfigurator(), flowNodeParameters, (int)Math.round(graphNode.getX()), (int)Math.round(graphNode.getY()), (int)Math.round(graphNode.getWidth()), (int)Math.round(graphNode.getHeight()), graphNode.isBypassed());
            flowNode.setStandardOutputFile(graphNode.getStandardOutputFile());
            flowNode.setExitCodeLogFile(graphNode.getExitCodeLogFile());
            flowNode.setHasExitCode(graphNode.hasExitCode());
            flowNodes.add(flowNode);
        }
        HashSet<FlowLink> flowLinks = new HashSet<FlowLink>();
        for (GraphLink graphLink : links) {
            GraphNode outputGraphNode;
            GraphNode inputGraphNode;
            LinkedList<Point> points = new LinkedList<Point>();
            for (Point2D point2D : graphLink.getPointList()) {
                points.add(new Point((int)Math.round(point2D.getX()), (int)Math.round(point2D.getY())));
            }
            LinkParameter inputLinkParameter = null;
            GraphFileDescriptor inputFileDescriptor = graphLink.getInputFileDescriptor();
            if (inputFileDescriptor != null && (inputGraphNode = inputFileDescriptor.getNode()) != null) {
                inputLinkParameter = new LinkParameter(inputGraphNode.getId(), inputFileDescriptor.getParameterName(), inputFileDescriptor.getParameterLabel());
                points.remove(points.size() - 1);
            }
            LinkParameter outputLinkParameter = null;
            GraphFileDescriptor outputFileDescriptor = graphLink.getOutputFileDescriptor();
            if (outputFileDescriptor != null && (outputGraphNode = outputFileDescriptor.getNode()) != null) {
                outputLinkParameter = new LinkParameter(outputGraphNode.getId(), outputFileDescriptor.getParameterName(), outputFileDescriptor.getParameterLabel());
                points.remove(0);
            }
            FlowLink flowLink = new FlowLink(graphLink.getId(), outputLinkParameter, inputLinkParameter, points);
            flowLinks.add(flowLink);
        }
        return new Flow(flowName, flowDescription, flowNodes, flowLinks);
    }

    @Override
    public ViewValidationResult validate(ValidationMode mode) {
        Collection<GraphNode> nodeCollection = this.getNodeCollection();
        if (nodeCollection.isEmpty()) {
            LocalizedMessage message = new LocalizedMessage(Graph.class, "error_empty_graph");
            return new ViewValidationResult(message, (ViewValidator)this);
        }
        return this.nodeValidation(mode, false);
    }

    public ViewValidationResult nodeValidation(ValidationMode mode, boolean highlight) {
        ViewValidationResult validation = null;
        Collection<GraphNode> nodeCollection = this.getNodeCollection();
        for (GraphNode node : nodeCollection) {
            ViewValidationResult nodeValidation = node.validate(mode);
            if (highlight) {
                node.highlightValidationResult(nodeValidation);
            }
            if (validation != null || nodeValidation.isWellSucceded()) continue;
            validation = new ViewValidationResult(nodeValidation.getMessage(), (ViewValidator)node);
        }
        return new ViewValidationResult(this);
    }

    @Override
    public void wasAnchored(GraphLink link, GraphFileDescriptor fileDescriptor) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasLinkAnchored(this, link, fileDescriptor);
        }
    }

    @Override
    public void wasDragged(GraphElement element, double tx, double ty) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasElementDragged(this, element, tx, ty);
        }
    }

    @Override
    public void wasDragged(GraphElement element, Point2D startPoint, Point2D endPoint) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasElementDragged(this, element, startPoint, endPoint);
        }
    }

    @Override
    public void wasDropped(GraphElement element, Point2D point) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasElementDropped(this, element, point);
        }
    }

    @Override
    public void wasIncreased(GraphLink link) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasLinkIncreased(this, link);
        }
    }

    @Override
    public void wasLinkStatusChanged(GraphLink link) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasLinkStatusChanged(this, link);
        }
    }

    @Override
    public void wasParameterSetEnabled(GraphNode node, String parameterName, boolean isEnabled) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasParameterSetEnabled(this, node, parameterName, isEnabled);
        }
    }

    @Override
    public void wasParameterSetVisible(GraphNode node, String parameterName, boolean isVisible) {
        for (GraphListener listener : this.graphListenerList) {
            listener.wasParameterSetVisible(this, node, parameterName, isVisible);
        }
    }

    @Override
    public void wasParametrized(GraphElement element) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasElementParametrized(this, element);
        }
    }

    @Override
    public void wasRenamed(GraphNode node) {
    }

    @Override
    public void wasResized(GraphNode node) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasNodeResized(this, node);
        }
    }

    @Override
    public void wasSelected(GraphElement element) {
        if (element.isSelected()) {
            this.bringToFront(element);
        }
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasElementSelected(this, element);
        }
    }

    @Override
    public void wasUnanchored(GraphLink link, GraphFileDescriptor fileDescriptor) {
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasLinkUnanchored(this, link, fileDescriptor);
        }
    }

    boolean addElement(GraphElement element) {
        if (this.getVOs().contains((Object)element)) {
            return false;
        }
        this.insertElement(element);
        element.addListener(this);
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasElementCreated(this, element);
        }
        return true;
    }

    void bringToFront(GraphElement element) {
        this.getVOs().remove((Object)element);
        this.insertElement(element);
    }

    GraphLink createLink(GraphFileDescriptor outputFileType) {
        GraphLink link = new GraphLink(this, this.generateId(null));
        link.setSelected(true);
        link.attach();
        link.increase(new Point2D.Double());
        link.start(outputFileType);
        return link;
    }

    void removeElement(GraphElement element) {
        this.getVOs().remove((Object)element);
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasElementRemoved(this, element);
        }
    }

    private GraphLink createGraphLink(FlowLink flowLink) {
        GraphNode outputGraphNode;
        GraphNode inputGraphNode;
        GraphFileDescriptor inputFileDescriptor = null;
        LinkParameter inputLinkParameter = flowLink.getInput();
        if (inputLinkParameter != null && (inputGraphNode = this.getNode(inputLinkParameter.getNodeId())) != null) {
            AbstractFileParameter fileParameter;
            inputFileDescriptor = inputGraphNode.getInputFileDescriptor(inputLinkParameter.getName());
            if (inputFileDescriptor == null) {
                inputFileDescriptor = new GraphFileDescriptor(inputLinkParameter.getName(), inputLinkParameter.getLabel(), false, inputGraphNode);
                inputGraphNode.addInputFileDescriptor(inputFileDescriptor);
            }
            if ((fileParameter = inputFileDescriptor.getFileParameter()) != null) {
                fileParameter.setValue(null);
            }
        }
        GraphFileDescriptor outputFileDescriptor = null;
        LinkParameter outputLinkParameter = flowLink.getOutput();
        if (outputLinkParameter != null && (outputGraphNode = this.getNode(outputLinkParameter.getNodeId())) != null) {
            AbstractFileParameter fileParameter;
            outputFileDescriptor = outputGraphNode.getOutputFileDescriptor(outputLinkParameter.getName());
            if (outputFileDescriptor == null) {
                outputFileDescriptor = new GraphFileDescriptor(outputLinkParameter.getName(), outputLinkParameter.getLabel(), true, outputGraphNode);
                outputGraphNode.addOutputFileDescriptor(outputFileDescriptor);
            }
            if ((fileParameter = outputFileDescriptor.getFileParameter()) != null) {
                fileParameter.setValue(null);
            }
        }
        LinkedList<Point2D> points = new LinkedList<Point2D>();
        for (Point point : flowLink.getPoints()) {
            points.add(new Point2D.Double(point.getX(), point.getY()));
        }
        return this.createGraphLink(flowLink.getId(), inputFileDescriptor, outputFileDescriptor, points);
    }

    private void createGraphLinks(Flow flow) {
        for (FlowLink flowLink : flow.getLinks()) {
            this.createGraphLink(flowLink);
        }
    }

    private GraphNode createGraphNode(FlowNode flowNode) throws ParseException, RemoteException, ParameterNotFoundException {
        GraphNode newNode;
        Point2D.Double nodePoint = new Point2D.Double(flowNode.getX(), flowNode.getY());
        Dimension nodeDimension = new Dimension(flowNode.getWidth(), flowNode.getHeight());
        AlgorithmInfo nodeAlgorithm = ClientRemoteLocator.algorithmService.getInfo(flowNode.getAlgorithmName());
        boolean bypassed = flowNode.isBypassed();
        if (nodeAlgorithm == null) {
            newNode = this.createGraphNode(flowNode.getId(), flowNode.getAlgorithmName(), flowNode.getAlgorithmVersionId(), (Point2D)nodePoint, (Dimension2D)nodeDimension, bypassed);
        } else {
            AlgorithmVersionInfo nodeAlgorithmVersion = nodeAlgorithm.getVersionInfo((Object)flowNode.getAlgorithmVersionId());
            if (nodeAlgorithmVersion == null) {
                newNode = this.createGraphNode(flowNode.getId(), nodeAlgorithm, flowNode.getAlgorithmVersionId(), (Point2D)nodePoint, (Dimension2D)nodeDimension, bypassed);
            } else {
                AlgorithmConfiguratorView nodeConfiguratorView = AlgorithmConfiguratorFactory.getInstance().createConfigurationView(this.window, nodeAlgorithmVersion, ValidationMode.ALLOW_EMPY_VALUES);
                if (nodeConfiguratorView == null) {
                    return null;
                }
                newNode = this.createGraphNode(flowNode.getId(), nodeConfiguratorView, nodePoint, nodeDimension, bypassed);
            }
        }
        newNode.setStandardOutputFile(flowNode.getStandardOutputFile());
        newNode.setHasExitCode(flowNode.hasExitCode());
        newNode.setExitCodeLogFile(flowNode.getExitCodeLogFile());
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (NodeParameter nodeParameter : flowNode.getParameters()) {
            String parameterName = nodeParameter.getName();
            AlgorithmConfiguratorView configuratorView = newNode.getAlgorithmConfiguratorView();
            if (configuratorView == null) {
                String parameterLabel = nodeParameter.getLabel();
                String parameterType = nodeParameter.getType();
                newNode.addParameter(parameterName, parameterLabel, parameterType);
            }
            String parameterValue = nodeParameter.getValue();
            parameterValues.put(parameterName, parameterValue);
        }
        newNode.setParameterValuesByName(Collections.unmodifiableMap(parameterValues));
        return newNode;
    }

    private void createGraphNodes(Flow flow) throws ParseException, RemoteException {
        for (FlowNode flowNode : flow.getNodes()) {
            try {
                this.createGraphNode(flowNode);
            }
            catch (ParameterNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void handlePickGraphMessage(PickGraphMessage message) {
        message.setGraph(this);
    }

    private boolean handleRemoveElementsMessage() {
        LinkedList<GraphElement> elementToRemoveList = new LinkedList<GraphElement>();
        for (GraphElement element : this.getVOs()) {
            if (!element.isSelected()) continue;
            elementToRemoveList.add(element);
        }
        if (elementToRemoveList.isEmpty()) {
            return false;
        }
        for (GraphElement elementToRemove : elementToRemoveList) {
            elementToRemove.deattach();
        }
        this.repaint();
        return true;
    }

    private void handleResetMessage() {
        for (int ix = 0; ix < this.getVOs().size(); ++ix) {
            GraphElement element = this.getVOs().get(ix);
            element.reset();
        }
        for (GraphListener graphListener : this.graphListenerList) {
            graphListener.wasReseted(this);
        }
        this.repaint();
    }

    private void handlePasteMessage(PasteMessage pasteMessage) {
        Transferable transferable = pasteMessage.getTransferable();
        if (transferable instanceof FlowTransferable) {
            FlowTransferable flowTransferable = (FlowTransferable)transferable;
            try {
                Flow flow = flowTransferable.getTransferData(FlowTransferable.DATA_FLAVOR);
                Graph copyGraph = new Graph(this.getParentWindow(), flow);
                int gridSize = 12;
                copyGraph.translate(new Point2D.Float(gridSize, gridSize));
                Collection<GraphElement> elements = this.merge(copyGraph);
                pasteMessage.setAffectedElements(elements);
            }
            catch (Exception e) {
                StandardErrorDialogs.showErrorDialog(this.getParentWindow(), e);
            }
        }
    }

    private void insertElement(GraphElement element) {
        if (element instanceof GraphLink) {
            this.getVOs().add(0, element);
        } else if (element instanceof GraphNode) {
            if (this.getVOs().isEmpty()) {
                this.getVOs().add(0, element);
            } else {
                for (int i = 0; i < this.getVOs().size(); ++i) {
                    GraphElement vo = this.getVOs().get(i);
                    if (!(vo instanceof GraphNode)) continue;
                    this.getVOs().add(i, element);
                    break;
                }
            }
        } else {
            String errorMessage = MessageFormat.format("O elemento {0} \u00e9 de um tipo desconhecido ({1}).", new Object[]{element, ((Object)((Object)element)).getClass().getName()});
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public boolean highlightValidationResult(ViewValidationResult result) {
        ViewValidator element = (ViewValidator)result.getElement();
        if (element != null && !element.equals(this)) {
            return element.highlightValidationResult(result);
        }
        return false;
    }

    public void setVersionInfoVisible(boolean visible) {
        this.versionInfoVisible = visible;
        Collection<GraphNode> nodeCollection = this.getNodeCollection();
        for (GraphNode graphNode : nodeCollection) {
            graphNode.setVersionInfoVisible(visible);
        }
    }

    protected boolean isVersionInfoVisible() {
        return this.versionInfoVisible;
    }

    protected boolean isIdAvailable(int id) {
        return this.getNode(id) == null && this.getLink(id) == null;
    }

    public java.awt.Point findPositionForNewNode() {
        if (!this.hasElements()) {
            return INITIAL_POINT;
        }
        Rectangle2D bounds = this.getBounds2D();
        java.awt.Point p = new java.awt.Point();
        p.setLocation(bounds.getCenterX(), bounds.getMaxY() + 24.0);
        return p;
    }

    public void translate(Point2D point) {
        for (GraphNode graphNode : this.getNodeCollection()) {
            graphNode.translate(point);
        }
        for (GraphLink graphLink : this.getLinkCollection()) {
            graphLink.translate(point);
        }
    }
}

