/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectAdminInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class AllocateAreaTask
extends ProjectsManagerTask<Boolean> {
    private final List<ProjectsManagerData> projects;
    private final boolean allocate;

    public AllocateAreaTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects, boolean allocate) {
        super(projectsManager);
        this.projects = projects;
        this.allocate = allocate;
    }

    protected void performTask() throws RemoteException {
        ProjectAdminInfo[] prjAdmInfo = ProjectAdminInfo.getAll();
        if (prjAdmInfo == null) {
            this.setResult(false);
            return;
        }
        ArrayList<ProjectAdminInfo> selectedProjects = new ArrayList<ProjectAdminInfo>();
        if (this.allocate) {
            for (ProjectAdminInfo p : prjAdmInfo) {
                for (ProjectsManagerData prj : this.projects) {
                    if (!p.isLocked() || !p.getProjectName().equals(prj.getProjectName()) || !p.getOwnerId().equals(prj.getOwnerId())) continue;
                    p.setAreaLockedSize(p.getAreaRequestSize());
                    selectedProjects.add(p);
                }
            }
            if (selectedProjects.size() == 0) {
                this.setResult(true);
                return;
            }
            ProjectAdminInfo[] sp = selectedProjects.toArray(new ProjectAdminInfo[selectedProjects.size()]);
            ProjectAdminInfo.allocateAreaForProjects((ProjectAdminInfo[])sp);
            this.saveInfoToProjectHistory();
        } else {
            for (ProjectAdminInfo p : prjAdmInfo) {
                for (ProjectsManagerData prj : this.projects) {
                    if (!p.isWaitingAreaFree() || !p.getProjectName().equals(prj.getProjectName()) || !p.getOwnerId().equals(prj.getOwnerId())) continue;
                    selectedProjects.add(p);
                }
            }
            ProjectAdminInfo[] sp = selectedProjects.toArray(new ProjectAdminInfo[selectedProjects.size()]);
            ProjectAdminInfo.freeAreaForProjects((ProjectAdminInfo[])sp);
        }
        this.setResult(true);
    }

    private void saveInfoToProjectHistory() throws RemoteException {
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        for (ProjectsManagerData prj : this.projects) {
            CommonClientProject ccp = psi.openProject(prj.getProjectId(), false);
            ProjectsManagerUI.addAutomaticHistoryBlock(ccp, ProjectHistoryBlockType.AREA_ALLOCATED);
        }
    }
}

