/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationManagerMenuUtilities;
import csbase.client.applicationmanager.ApplicationPanel;
import csbase.client.applicationmanager.ClearApplicationCacheAction;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopPref;
import csbase.client.desktop.TreeFilterPanelListener;
import csbase.client.ias.AdminFrame;
import csbase.client.ias.AdminModifyUserInfoDialog;
import csbase.client.ias.ModifyUserInfoDialog;
import csbase.client.kernel.ClientException;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.project.BasicProjectTreeFactory;
import csbase.client.project.ProjectLocationBar;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.project.ProjectTreeFactory;
import csbase.client.project.action.CommonProjectCreationAction;
import csbase.client.project.action.CommonProjectOpenAction;
import csbase.client.project.action.CommonProjectUpdateAction;
import csbase.client.project.action.ProjectCloseAction;
import csbase.client.project.action.ProjectDeleteAction;
import csbase.client.project.action.ProjectHistoryShowAction;
import csbase.client.project.action.ProjectTreeUpdateAction;
import csbase.client.project.action.ProjectUsersManagementAction;
import csbase.client.project.action.ShowHiddenFilesAction;
import csbase.client.project.action.ShowTreeFilterAction;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.ProjectAdminObserver;
import csbase.client.remote.srvproxies.ApplicationManagementProxy;
import csbase.logic.AlgorithmAdminPermission;
import csbase.logic.CommonClientProject;
import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectUserEvent;
import csbase.logic.SGAAdminPermission;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class BasicDesktopFrame
extends DesktopFrame
implements Observer {
    private ProjectLocationBar locationBar;
    private JButton openProjButton;
    private JMenuItem openProjMenuItem;
    private JMenuItem fileTransferMenuItem;
    private JMenuItem removeProjMenuItem;
    private ApplicationPanel applicationPanel;
    private static final String ALGORITHMS_MANAGER_APPLICATION_ID = "algorithmsmanager";

    public BasicDesktopFrame() throws ClientException {
        this.createProjectTreeFactory();
        this.setTitle(Client.getInstance().getSystemName());
        DesktopComponentFrame mainFrame = this.getDesktopFrame();
        JComponent projectPanel = this.createProjectPanel();
        this.applicationPanel = new ApplicationPanel();
        this.applicationPanel.addProjectTreeListernerForLayoutAutoPersistency(this.projectTree);
        this.applicationPanel.addMouseListenerForLayoutMenu();
        this.applicationPanel.addMouseListenerForApplicationsMenu();
        JComponent mainPanel = this.composeMainPanel(projectPanel, this.createDirectoryContentsPanel(), this.createTreeFilterPanel(), this.applicationPanel, this.createNotificationPanel());
        JPanel firstPanel = new JPanel(new BorderLayout());
        firstPanel.add((Component)this.createToolBar(), "North");
        firstPanel.add((Component)mainPanel, "Center");
        ((JFrame)mainFrame).getContentPane().add(firstPanel);
        this.createDesktopMenuBar();
        ProjectAdminObserver.getInstance().addObserver(this);
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BasicDesktopFrame.this.exitApplication();
            }
        });
    }

    protected String getProperty(String name) {
        return this.getConfiguration().getOptionalProperty(name);
    }

    public final ApplicationPanel getApplicationPanel() {
        return this.applicationPanel;
    }

    private JComponent createProjectPanel() throws ClientException {
        ProjectTreeFactory projectTreeFactory = ProjectTreeFactory.getInstance();
        String title = this.getTitle();
        DesktopComponentFrame desktopFrame = this.getDesktopFrame();
        this.projectTree = projectTreeFactory.makeProjectTree(desktopFrame, title);
        this.projectTree.addMouseListener();
        this.projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject proj) {
                BasicDesktopFrame.this.applicationPanel.setProjectFlag(proj != null);
                BasicDesktopFrame.this.treeFilterPanel.setVisible(false);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.projectTree.getTree());
        this.projectTreePanel = new JPanel(new BorderLayout());
        this.projectTreePanel.add((Component)scrollPane, "Center");
        return this.projectTreePanel;
    }

    protected void createProjectTreeFactory() {
        new BasicProjectTreeFactory();
    }

    private JComponent composeMainPanel(JComponent proTreePanel, JComponent dirContPanel, JComponent filterPanel, JComponent appPanel, JComponent notificationPanel) {
        this.locationBar = new ProjectLocationBar(this.projectTree);
        proTreePanel.add((Component)this.locationBar, "North");
        this.splitPaneBetweenTreeAndTable = new JSplitPane(0, proTreePanel, dirContPanel);
        this.splitPaneBetweenTreeAndTable.setOneTouchExpandable(true);
        this.splitPaneBetweenTreeAndTable.setResizeWeight(0.75);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.treeFilterPanel, "North");
        panel.add((Component)this.splitPaneBetweenTreeAndTable, "Center");
        this.splitPaneBetweenTreeAndApp = new JSplitPane(1, panel, appPanel);
        this.splitPaneBetweenTreeAndApp.setOneTouchExpandable(true);
        this.splitPaneBetweenTreeAndApp.setResizeWeight(0.0);
        this.splitPaneBetweenAppAndNotif = new JSplitPane(0, this.splitPaneBetweenTreeAndApp, notificationPanel);
        this.splitPaneBetweenAppAndNotif.setOneTouchExpandable(true);
        this.splitPaneBetweenAppAndNotif.setResizeWeight(1.0);
        this.getDesktopFrame().setResizable(true);
        return this.splitPaneBetweenAppAndNotif;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        this.openProjButton = new JButton(new CommonProjectOpenAction(this.projectTree));
        this.openProjButton.setIcon(ApplicationImages.ICON_OPEN_16);
        this.openProjButton.setText("");
        this.openProjButton.setEnabled(User.getLoggedUser().isAdmin() || this.userHasProject() || this.userHasOthersProject());
        toolBar.add(this.openProjButton);
        toolBar.addSeparator();
        JButton cascadeButton = new JButton();
        cascadeButton.setIcon(ApplicationImages.ICON_WINCASCADE_16);
        cascadeButton.setToolTipText(LNG.get((String)"desktop.groups.cascade"));
        cascadeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDesktopFrame.this.applicationPanel.cascadeGroups();
            }
        });
        JButton tileVertButton = new JButton();
        tileVertButton.setIcon(ApplicationImages.ICON_WINTILEVERTICAL_16);
        tileVertButton.setToolTipText(LNG.get((String)"desktop.groups.tile_vertical"));
        tileVertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDesktopFrame.this.applicationPanel.tileGroupsVertical();
            }
        });
        JButton tileHorButton = new JButton();
        tileHorButton.setIcon(ApplicationImages.ICON_WINTILEHORIZONTAL_16);
        tileHorButton.setToolTipText(LNG.get((String)"desktop.groups.tile_horizontal"));
        tileHorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDesktopFrame.this.applicationPanel.tileGroupsHorizontal();
            }
        });
        final JToggleButton showTreeFilterButton = new JToggleButton(new ShowTreeFilterAction(this.treeFilterPanel));
        showTreeFilterButton.setIcon(ApplicationImages.ICON_FILTER_16);
        showTreeFilterButton.setText("");
        showTreeFilterButton.setToolTipText(LNG.get((String)"BasicDesktopFrame.tooltip.showTreeFilterButton"));
        showTreeFilterButton.setEnabled(false);
        this.enableIfProjectOpened(showTreeFilterButton);
        this.treeFilterPanel.addListener(new TreeFilterPanelListener(){

            @Override
            public void visibilityChanged(boolean panelVisible) {
                showTreeFilterButton.setSelected(panelVisible);
            }
        });
        toolBar.add(cascadeButton);
        toolBar.add(tileVertButton);
        toolBar.add(tileHorButton);
        toolBar.addSeparator();
        toolBar.add(showTreeFilterButton);
        toolBar.addSeparator();
        JButton srvMonitorButton = toolBar.add(this.applicationPanel.getApplicationAction("sgamonitor"));
        srvMonitorButton.setToolTipText(LNG.get((String)"BasicDesktopFrame.tooltip.sgamonitor"));
        JButton cmdMonitorButton = toolBar.add(this.applicationPanel.getApplicationAction("commandmonitor"));
        cmdMonitorButton.setToolTipText(LNG.get((String)"BasicDesktopFrame.tooltip.commandmonitor"));
        toolBar.addSeparator();
        return toolBar;
    }

    private void createDesktopMenuBar() {
        JMenu optionalMenu;
        JMenu appMenu;
        boolean includeAlgorithmMenu = this.getConfiguration().getOptionalBooleanProperty("algorithm.menu", true);
        boolean leadingConfigMenu = this.getConfiguration().getOptionalBooleanProperty("leading.config.menu", false);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createProjectMenu());
        JMenu configMenu = this.createConfigurationMenu();
        if (leadingConfigMenu) {
            menuBar.add(configMenu);
        }
        if ((appMenu = ApplicationManagerMenuUtilities.buildMenu(LNG.get((String)"desktop.applications"))) != null) {
            menuBar.add(appMenu);
        }
        if (includeAlgorithmMenu) {
            menuBar.add(this.createAlgorithmMenu());
        }
        menuBar.add(this.createMonitoringMenu());
        if (!leadingConfigMenu) {
            menuBar.add(configMenu);
        }
        User user = User.getLoggedUser();
        AlgorithmAdminPermission algoPerm = (AlgorithmAdminPermission)user.getPermission(AlgorithmAdminPermission.class);
        SGAAdminPermission sgaPerm = (SGAAdminPermission)user.getPermission(SGAAdminPermission.class);
        if (user.isAdmin() || algoPerm != null || sgaPerm != null) {
            menuBar.add(this.createAdminMenu());
        }
        if ((optionalMenu = this.createOptionalMenu()) != null) {
            menuBar.add(optionalMenu);
        }
        this.setMenuBar(menuBar);
    }

    private JMenu createProjectMenu() {
        JMenu menu = new JMenu(LNG.get((String)"desktop.project"));
        boolean hasOwnProjects = this.userHasProject();
        boolean hasOtherProjects = User.getLoggedUser().isAdmin() || this.userHasOthersProject();
        Icon emptyIcon = GUIUtils.createEmptyIcon((int)6, (int)6);
        JMenuItem createMenuItem = new JMenuItem(new CommonProjectCreationAction(this.projectTree));
        createMenuItem.setText(LNG.get((String)"desktop.project.create"));
        createMenuItem.setIcon(emptyIcon);
        createMenuItem.setEnabled(true);
        menu.add(createMenuItem);
        this.openProjMenuItem = new JMenuItem(new CommonProjectOpenAction(this.projectTree));
        this.openProjMenuItem.setText(LNG.get((String)"desktop.project.open"));
        this.openProjMenuItem.setEnabled(User.getLoggedUser().isAdmin() || hasOwnProjects || hasOtherProjects);
        this.openProjMenuItem.setIcon(ApplicationImages.ICON_OPEN_16);
        menu.add(this.openProjMenuItem);
        this.removeProjMenuItem = new JMenuItem(new ProjectDeleteAction(this.projectTree));
        this.removeProjMenuItem.setText(LNG.get((String)"desktop.project.remove"));
        this.removeProjMenuItem.setIcon(emptyIcon);
        this.removeProjMenuItem.setEnabled(hasOwnProjects);
        menu.add(this.removeProjMenuItem);
        this.fileTransferMenuItem = menu.add(this.applicationPanel.getApplicationAction("filetransfer"));
        this.fileTransferMenuItem.setText(LNG.get((String)"desktop.project.file_transfer"));
        this.fileTransferMenuItem.setIcon(emptyIcon);
        this.fileTransferMenuItem.setEnabled(hasOwnProjects);
        menu.addSeparator();
        JMenu getDataSubmenu = this.createDataRetrievalMenu();
        if (getDataSubmenu != null) {
            getDataSubmenu.setEnabled(false);
            getDataSubmenu.setIcon(emptyIcon);
            this.enableIfProjectOpened(getDataSubmenu);
            menu.add(getDataSubmenu);
        }
        JMenuItem updateTreeMenuItem = new JMenuItem(new ProjectTreeUpdateAction(this.projectTree));
        updateTreeMenuItem.setEnabled(false);
        updateTreeMenuItem.setIcon(emptyIcon);
        this.enableIfProjectOpened(updateTreeMenuItem);
        menu.add(updateTreeMenuItem);
        JMenuItem historyViewMenuItem = new JMenuItem(new ProjectHistoryShowAction(this.projectTree));
        historyViewMenuItem.setText(LNG.get((String)"desktop.project.history"));
        historyViewMenuItem.setIcon(emptyIcon);
        historyViewMenuItem.setEnabled(false);
        this.enableIfProjectOpened(historyViewMenuItem);
        menu.add(historyViewMenuItem);
        JMenuItem updateMenuItem = new JMenuItem(new CommonProjectUpdateAction(this.projectTree));
        updateMenuItem.setText(LNG.get((String)"desktop.project.modify"));
        updateMenuItem.setIcon(emptyIcon);
        updateMenuItem.setEnabled(false);
        this.enableIfProjectOpened(updateMenuItem);
        menu.add(updateMenuItem);
        JMenuItem usersManagementMenuItem = new JMenuItem(new ProjectUsersManagementAction(this.projectTree));
        usersManagementMenuItem.setText(LNG.get((String)"desktop.project.access.control"));
        usersManagementMenuItem.setEnabled(false);
        usersManagementMenuItem.setIcon(emptyIcon);
        this.enableIfAdminProject(usersManagementMenuItem);
        menu.add(usersManagementMenuItem);
        final JCheckBoxMenuItem showTreeFilterMenuItem = new JCheckBoxMenuItem(new ShowTreeFilterAction(this.treeFilterPanel));
        showTreeFilterMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl pressed F"));
        showTreeFilterMenuItem.setEnabled(false);
        this.enableIfProjectOpened(showTreeFilterMenuItem);
        this.treeFilterPanel.addListener(new TreeFilterPanelListener(){

            @Override
            public void visibilityChanged(boolean panelVisible) {
                showTreeFilterMenuItem.setSelected(panelVisible);
            }
        });
        menu.add(showTreeFilterMenuItem);
        JCheckBoxMenuItem showHiddenFilesMenuItem = new JCheckBoxMenuItem(new ShowHiddenFilesAction(this.projectTree));
        PreferenceCategory dp = this.getDesktopPreferences();
        boolean showHiddenFilesPref = dp.getPreferenceAsBoolean(DesktopPref.SHOW_HIDDEN_FILES);
        showHiddenFilesMenuItem.setSelected(showHiddenFilesPref);
        showHiddenFilesMenuItem.setEnabled(false);
        this.enableIfProjectOpened(showHiddenFilesMenuItem);
        menu.add(showHiddenFilesMenuItem);
        JMenuItem closeMenuItem = new JMenuItem(new ProjectCloseAction(this.projectTree));
        closeMenuItem.setEnabled(false);
        closeMenuItem.setIcon(emptyIcon);
        this.enableIfProjectOpened(closeMenuItem);
        menu.add(closeMenuItem);
        menu.addSeparator();
        JMenuItem exitMenuItem = menu.add(LNG.get((String)"desktop.exit"));
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDesktopFrame.this.exitApplication();
            }
        });
        exitMenuItem.setIcon(emptyIcon);
        menu.add(exitMenuItem);
        return menu;
    }

    protected JMenu createRecentProjectsMenu() {
        final JMenu recentProjectsMenu = new JMenu(LNG.get((String)"DesktopFrame.menu.project.recents"));
        this.updateRecentProjectsMenu(recentProjectsMenu);
        this.projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject project) {
                BasicDesktopFrame.this.updateRecentProjectsMenu(recentProjectsMenu);
            }
        });
        return recentProjectsMenu;
    }

    private void updateRecentProjectsMenu(JMenu recentProjectsMenu) {
        recentProjectsMenu.removeAll();
        AbstractAction[] openProjectActions = this.getRecentProjectOpenActions();
        for (int i = 0; i < openProjectActions.length; ++i) {
            recentProjectsMenu.add(openProjectActions[i]);
        }
        recentProjectsMenu.setEnabled(recentProjectsMenu.getSubElements().length > 0);
    }

    protected JMenu createDataRetrievalMenu() {
        JMenu menu = new JMenu(LNG.get((String)"desktop.project.data_retrieval"));
        return menu;
    }

    private JMenu createAlgorithmMenu() {
        JMenu menu = new JMenu(LNG.get((String)"desktop.algorithms"));
        JMenuItem execMenuItem = menu.add(LNG.get((String)"desktop.algorithms.execute"));
        execMenuItem.addActionListener(this.applicationPanel.getApplicationAction("executor"));
        execMenuItem.setEnabled(false);
        this.enableIfProjectOpened(execMenuItem);
        return menu;
    }

    private JMenu createMonitoringMenu() {
        JMenu menu = new JMenu(LNG.get((String)"desktop.monitoring"));
        JMenuItem serversMenuItem = menu.add(this.applicationPanel.getApplicationAction("sgamonitor"));
        serversMenuItem.setText(LNG.get((String)"desktop.monitoring.servers"));
        JMenuItem cmdsMenuItem = menu.add(this.applicationPanel.getApplicationAction("commandmonitor"));
        cmdsMenuItem.setText(LNG.get((String)"desktop.monitoring.commands"));
        List<JMenuItem> diskItems = this.createDiskMonitoringMenuItems();
        if (diskItems != null && diskItems.size() > 0) {
            menu.addSeparator();
            for (JMenuItem item : diskItems) {
                menu.add(item);
            }
        }
        this.addOptionalMonitoringItems(menu);
        return menu;
    }

    protected void addOptionalMonitoringItems(JMenu monitoringMenu) {
    }

    protected List<JMenuItem> createDiskMonitoringMenuItems() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        JMenuItem diskinfoMenuItem = new JMenuItem(this.applicationPanel.getApplicationAction("diskinfo"));
        diskinfoMenuItem.setText(LNG.get((String)"desktop.monitoring.disk"));
        items.add(diskinfoMenuItem);
        JMenuItem diskAreaMenuItem = new JMenuItem(this.applicationPanel.getApplicationAction("projectdiskmonitor"));
        diskAreaMenuItem.setText(LNG.get((String)"desktop.monitoring.project_area"));
        items.add(diskAreaMenuItem);
        return items;
    }

    private JMenu createConfigurationMenu() {
        JMenu menu = new JMenu(LNG.get((String)"desktop.config"));
        this.addOptionalConfigItems(menu);
        JMenuItem configUserMenuItem = menu.add(LNG.get((String)"desktop.config.user"));
        configUserMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopComponentFrame frame = DesktopFrame.getInstance().getDesktopFrame();
                User loggedUser = User.getLoggedUser();
                ModifyUserInfoDialog dialog = loggedUser.isAdmin() ? new AdminModifyUserInfoDialog((Window)frame, loggedUser.getId()) : new ModifyUserInfoDialog((Window)frame, loggedUser.getId());
                dialog.setVisible(true);
            }
        });
        menu.addSeparator();
        menu.add(this.applicationPanel.createGroupsConfigurationMenu());
        menu.add(this.createProjectAutoUpdateItem());
        menu.add(this.createRestoreDesktopItem());
        menu.addSeparator();
        menu.add(new ClearApplicationCacheAction());
        return menu;
    }

    @Override
    public void showDesktop() {
        super.showDesktop();
        this.applicationPanel.tileGroupsHorizontal();
    }

    protected void addOptionalConfigItems(JMenu configMenu) {
    }

    private JMenu createAdminMenu() {
        boolean first = true;
        JMenu menu = new JMenu(LNG.get((String)"desktop.admin"));
        User user = User.getLoggedUser();
        if (user.isAdmin()) {
            JMenuItem userMenuItem = menu.add(LNG.get((String)"desktop.admin.users"));
            userMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BasicDesktopFrame.this.adminFrame == null) {
                        BasicDesktopFrame.this.adminFrame = new AdminFrame();
                    }
                    BasicDesktopFrame.this.adminFrame.showUserManagement();
                }
            });
            JMenuItem unMenuItem = menu.add(LNG.get((String)"desktop.admin.userGroups"));
            unMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BasicDesktopFrame.this.adminFrame == null) {
                        BasicDesktopFrame.this.adminFrame = new AdminFrame();
                    }
                    BasicDesktopFrame.this.adminFrame.showUserGroupManagement();
                }
            });
            JMenuItem roleMenuItem = menu.add(LNG.get((String)"desktop.admin.roles"));
            roleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BasicDesktopFrame.this.adminFrame == null) {
                        BasicDesktopFrame.this.adminFrame = new AdminFrame();
                    }
                    BasicDesktopFrame.this.adminFrame.showRoleManagement();
                }
            });
            JMenuItem permissionMenuItem = menu.add(LNG.get((String)"desktop.admin.permissions"));
            permissionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BasicDesktopFrame.this.adminFrame == null) {
                        BasicDesktopFrame.this.adminFrame = new AdminFrame();
                    }
                    BasicDesktopFrame.this.adminFrame.showPermissionManagement();
                }
            });
            JMenuItem platformMenuItem = menu.add(LNG.get((String)"desktop.admin.platforms"));
            platformMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BasicDesktopFrame.this.adminFrame == null) {
                        BasicDesktopFrame.this.adminFrame = new AdminFrame();
                    }
                    BasicDesktopFrame.this.adminFrame.showPlatformManagement();
                }
            });
            first = false;
        }
        AlgorithmAdminPermission algoPermission = (AlgorithmAdminPermission)user.getPermission(AlgorithmAdminPermission.class);
        if (user.isAdmin() || algoPermission != null) {
            JMenuItem algorithmsManagerMenuItem;
            if (!first) {
                menu.addSeparator();
            }
            if ((algorithmsManagerMenuItem = this.createAlgorithmsManagerMenuItem()) != null) {
                menu.add(algorithmsManagerMenuItem);
            }
            first = false;
        }
        if (user.isAdmin()) {
            JMenuItem applicationsReloadMenuItem;
            if (!first) {
                menu.addSeparator();
            }
            if ((applicationsReloadMenuItem = this.createApplicationReloadMenuItem()) != null) {
                menu.add(applicationsReloadMenuItem);
                first = false;
            }
        }
        return menu;
    }

    private JMenuItem createApplicationReloadMenuItem() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ApplicationManagementProxy.reloadApplications(BasicDesktopFrame.this.getDesktopFrame());
            }
        };
        String text = LNG.get((String)"desktop.admin.applications.reload");
        JMenuItem menuItem = new JMenuItem(action);
        menuItem.setText(text);
        return menuItem;
    }

    private JMenuItem createAlgorithmsManagerMenuItem() {
        ApplicationRegistry reg;
        JMenuItem menuItem = new JMenuItem(LNG.get((String)"desktop.admin.algorithms"));
        ApplicationManager mgr = ApplicationManager.getInstance();
        if (mgr != null && (reg = mgr.getApplicationRegistry(ALGORITHMS_MANAGER_APPLICATION_ID)) != null && reg.isShownAtApplicationMenu()) {
            AbstractAction action = mgr.getApplicationAction(reg);
            menuItem = new JMenuItem(action);
        }
        return menuItem;
    }

    protected JMenu createOptionalMenu() {
        return null;
    }

    public void shutdownDesktop(ProjectCloseAction projCloseAction) {
        if (ClientRemoteMonitor.getInstance().isAlive() && !projCloseAction.close()) {
            return;
        }
        this.shutdownDesktop();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ProjectUserEvent) {
            final ProjectUserEvent event = (ProjectUserEvent)arg;
            final boolean hasProject = this.userHasProject();
            switch (event.type) {
                case 2: {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BasicDesktopFrame.this.openProjMenuItem.setEnabled(hasProject);
                            BasicDesktopFrame.this.removeProjMenuItem.setEnabled(hasProject);
                            BasicDesktopFrame.this.fileTransferMenuItem.setEnabled(hasProject);
                            BasicDesktopFrame.this.openProjButton.setEnabled(hasProject);
                            CommonProjectInfo info = (CommonProjectInfo)event.item;
                            if (BasicDesktopFrame.this.projectTree.getProject() != null && info.projectId.equals(BasicDesktopFrame.this.projectTree.getProject().getId())) {
                                BasicDesktopFrame.this.projectTree.resetProject();
                            }
                        }
                    });
                    break;
                }
                case 1: {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BasicDesktopFrame.this.openProjMenuItem.setEnabled(true);
                            BasicDesktopFrame.this.removeProjMenuItem.setEnabled(true);
                            BasicDesktopFrame.this.fileTransferMenuItem.setEnabled(true);
                            BasicDesktopFrame.this.openProjButton.setEnabled(true);
                        }
                    });
                }
            }
        }
    }

    public void exitApplication() {
        int answer;
        if (!ClientRemoteMonitor.getInstance().ping() && (answer = StandardDialogs.showYesNoDialog((Component)this.getDesktopFrame(), (String)this.getTitle(), (Object)LNG.get((String)"desktop.confirm_shutdown"))) != 0) {
            return;
        }
        this.notifPanel.setUser(null);
        this.shutdownDesktop(new ProjectCloseAction(this.projectTree));
    }
}

