/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser.filetablepanel;

import csbase.client.util.filechooser.ClientFileChooserCardinality;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.filetablepanel.ClientFileTableModel;
import csbase.client.util.filechooser.filetablepanel.ClientFileTableRenderer;
import csbase.client.util.filechooser.filetablepanel.ClientFileTableSelectionListener;
import csbase.client.util.filechooser.filetablepanel.ClientTableActionListener;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.logic.ClientFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.string.StringUtils;
import tecgraf.javautils.gui.table.SortableTable;

public class ClientFileTablePanel
extends JPanel {
    private final SortableTable table = new SortableTable();
    private ClientFileChooserSelectionMode selectionMode = ClientFileChooserSelectionMode.FILES_ONLY;
    private final ClientFileTableModel model;
    private final List<ClientTableActionListener> actionListeners = new ArrayList<ClientTableActionListener>();
    private final List<ClientFileTableSelectionListener> selectionListeners = new ArrayList<ClientFileTableSelectionListener>();
    private ClientFileChooserCardinality cardinality = ClientFileChooserCardinality.SINGLE_CHOOSE;

    public ClientFileTablePanel() {
        this.setLayout(new BorderLayout());
        this.model = new ClientFileTableModel(null, null, (Component)this.table);
        this.table.setModel((TableModel)this.model);
        this.table.setGridColor(this.table.getBackground());
        this.table.setFillsViewportHeight(true);
        this.initColumns();
        this.initComparators();
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.setCardinality(ClientFileChooserCardinality.SINGLE_CHOOSE);
        ClientFileTableRenderer renderer = new ClientFileTableRenderer();
        this.table.setDefaultRenderer(ClientFile.class, (TableCellRenderer)renderer);
        this.addTableKeyListener();
        this.addTableActionListener();
        this.addTableSelectionListener();
        JScrollPane scroll = new JScrollPane((Component)this.table);
        this.add((Component)scroll, "Center");
    }

    private void addTableKeyListener() {
        this.table.addKeyListener((KeyListener)new KeyAdapter(){
            private char currentChar = (char)32;
            private List<ClientFile> files = Collections.emptyList();
            private int index = 0;
            private ClientFile currentDir = null;

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                ClientFile dir = ClientFileTablePanel.this.model.getDirectory();
                if (c == this.currentChar && dir.equals(this.currentDir)) {
                    ++this.index;
                } else {
                    this.index = 0;
                    this.currentChar = c;
                    this.currentDir = dir;
                    this.files = Character.isLetterOrDigit(c) || c == '_' || c == '.' || c == '-' ? ClientFileTablePanel.this.model.getFilesWithPrefix(String.valueOf(c)) : Collections.emptyList();
                }
                int numFiles = this.files.size();
                if (numFiles > 0) {
                    int i = this.index % numFiles;
                    ArrayList<ClientFile> selection = new ArrayList<ClientFile>();
                    selection.add(this.files.get(i));
                    ClientFileTablePanel.this.setSelection(selection);
                    ClientFileTablePanel.this.scrollToSelection();
                }
            }
        });
    }

    protected void scrollToSelection() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            Rectangle cellRect = this.table.getCellRect(selectedRow, 0, true);
            this.table.scrollRectToVisible(cellRect);
        }
    }

    private void initColumns() {
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(40);
        columnModel.getColumn(1).setPreferredWidth(220);
        columnModel.getColumn(2).setPreferredWidth(110);
        columnModel.getColumn(3).setPreferredWidth(150);
        this.table.setAutoResizeMode(3);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
    }

    private void addTableActionListener() {
        final ClientFileTablePanel panel = this;
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.isControlDown() || me.isShiftDown()) {
                    return;
                }
                boolean isLeft = SwingUtilities.isLeftMouseButton(me);
                int clickCount = me.getClickCount();
                List<ClientFile> objects = ClientFileTablePanel.this.getSelectedClientProjectFiles();
                if (objects == null) {
                    return;
                }
                if (isLeft && clickCount == 2) {
                    for (ClientTableActionListener lst : ClientFileTablePanel.this.actionListeners) {
                        lst.actionPerformed(panel, objects);
                    }
                }
            }
        });
    }

    public final void addTablePanelActionListener(ClientTableActionListener listener) {
        this.actionListeners.add(listener);
    }

    public final void addTablePanelSelectionListener(ClientFileTableSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    private void addTableSelectionListener() {
        final ClientFileTablePanel panel = this;
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List<ClientFile> objects = ClientFileTablePanel.this.getSelectedClientProjectFiles();
                if (objects == null || objects.size() == 0) {
                    return;
                }
                for (ClientFileTableSelectionListener lst : ClientFileTablePanel.this.selectionListeners) {
                    lst.selectionPerformed(panel, objects);
                }
            }
        });
    }

    public final void delTablePanelActionListener(ClientTableActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public final void delTablePanelSelectionListener(ClientFileTableSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public final List<ClientFile> getClientProjectFileList() {
        ArrayList<ClientFile> objects = new ArrayList<ClientFile>();
        List<ClientFile> objectList = this.model.getFileList();
        objects.addAll(objectList);
        Collections.unmodifiableList(objects);
        return objects;
    }

    public final ClientFile getRootDirectory() {
        return this.model.getDirectory();
    }

    public final List<ClientFile> getSelectedClientProjectFiles() {
        int[] selectedRows;
        ArrayList<ClientFile> list = new ArrayList<ClientFile>();
        List<ClientFile> fileList = this.model.getFileList();
        for (int idx : selectedRows = this.table.getSelectedRows()) {
            int realIdx = this.table.convertRowIndexToModel(idx);
            ClientFile cpf = fileList.get(realIdx);
            list.add(cpf);
        }
        return list;
    }

    public final ClientFileChooserSelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    private void initComparators() {
        this.table.setNoSortStateEnabled(false);
        this.table.sort();
        Comparator<ClientFile> typeComparator = new Comparator<ClientFile>(){

            @Override
            public int compare(ClientFile o1, ClientFile o2) {
                String t2;
                boolean equalStructs;
                boolean bl = equalStructs = o1.isDirectory() == o2.isDirectory();
                if (!equalStructs) {
                    return o1.isDirectory() ? -1 : 1;
                }
                String t1 = o1.getType();
                boolean equalTypes = t1.equals(t2 = o2.getType());
                if (!equalTypes) {
                    return t1.compareTo(t2);
                }
                SortOrder sortOrder = ClientFileTablePanel.this.table.getCurrentSortOrder();
                boolean isAscending = sortOrder == SortOrder.ASCENDING;
                String n1 = o1.getName();
                String n2 = o2.getName();
                Comparator plain = StringUtils.getPlainSortComparator();
                int cmp = plain.compare(n1, n2);
                return isAscending ? cmp : -cmp;
            }
        };
        Comparator<ClientFile> sizeComparator = new Comparator<ClientFile>(){

            @Override
            public int compare(ClientFile o1, ClientFile o2) {
                boolean equalStructs;
                boolean bl = equalStructs = o1.isDirectory() == o2.isDirectory();
                if (equalStructs) {
                    Long c1 = o1.size();
                    Long c2 = o2.size();
                    return c1.compareTo(c2);
                }
                return o1.isDirectory() ? -1 : 1;
            }
        };
        Comparator<ClientFile> modComparator = new Comparator<ClientFile>(){

            @Override
            public int compare(ClientFile o1, ClientFile o2) {
                Long c1 = o1.getModificationDate();
                Long c2 = o2.getModificationDate();
                return c1.compareTo(c2);
            }
        };
        Comparator<ClientFile> nameComparator = new Comparator<ClientFile>(){

            @Override
            public int compare(ClientFile o1, ClientFile o2) {
                SortOrder sortOrder = ClientFileTablePanel.this.table.getCurrentSortOrder();
                boolean isAscending = sortOrder == SortOrder.ASCENDING;
                boolean isDir1 = o1.isDirectory();
                boolean isDir2 = o2.isDirectory();
                String n1 = o1.getName();
                String n2 = o2.getName();
                if (isDir1 && !isDir2) {
                    return isAscending ? -1 : 1;
                }
                if (!isDir1 && isDir2) {
                    return isAscending ? 1 : 1;
                }
                Comparator plain = StringUtils.getPlainSortComparator();
                return plain.compare(n1, n2);
            }
        };
        this.table.setComparator(0, (Comparator)typeComparator);
        this.table.setComparator(1, (Comparator)nameComparator);
        this.table.setComparator(2, (Comparator)sizeComparator);
        this.table.setComparator(3, (Comparator)modComparator);
    }

    public final ClientFileChooserCardinality getCardinality() {
        return this.cardinality;
    }

    public final void setFilter(ClientFileFilterInterface filter) {
        this.model.setFilter(filter);
    }

    public final void setRootDirectory(ClientFile directory) {
        this.model.setDirectory(directory);
    }

    public void setSelection(List<ClientFile> newSelection) {
        int nRows = this.model.getRowCount();
        this.table.clearSelection();
        if (newSelection == null) {
            return;
        }
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        for (int r = 0; r < nRows; ++r) {
            Object obj = this.table.getValueAt(r, 0);
            ClientFile file = (ClientFile)obj;
            if (!newSelection.contains(file)) continue;
            selectionModel.addSelectionInterval(r, r);
        }
    }

    public final void setSelectionMode(ClientFileChooserSelectionMode mode) {
        this.selectionMode = mode;
        this.table.clearSelection();
    }

    public final void setCardinality(ClientFileChooserCardinality flag) {
        int tableSelection;
        switch (flag) {
            case SINGLE_CHOOSE: {
                tableSelection = 0;
                break;
            }
            case MULTIPLE_CHOOSE: {
                tableSelection = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("bad value!");
            }
        }
        this.cardinality = flag;
        this.table.setSelectionMode(tableSelection);
        this.table.clearSelection();
    }

    public final void refresh() {
        this.model.refresh();
    }

    public final void showHiddenFiles(boolean flag) {
        this.model.showHiddenFiles(flag);
        this.refresh();
    }

    public final boolean isHiddenFilesShown() {
        return this.model.isHiddenFilesShown();
    }
}

