package csbase.client.algorithms.commands;

import csbase.remote.CommandPersistenceServiceInterface;

/**
 * Observador local do 
 * {@link CommandPersistenceServiceInterface servio de persistncia de comandos}.
 *
 * @author lmoreira
 */
public interface CommandPersistenceListener {

  /**
   * Indica que um comando foi removido.
   * 
   * @param projectId O identificador do projeto (No aceita {@code null}).
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void commandWasRemoved(Object projectId, String commandId);

  /**
   * Indica que um comando foi salvo.
   * 
   * @param projectId O identificador do projeto (No aceita {@code null}).
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void commandWasSaved(Object projectId, String commandId);

  /**
   * Indica que um comando foi atualizado.
   * 
   * @param projectId O identificador do projeto (No aceita {@code null}).
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void commandWasUpdated(Object projectId, String commandId);
}
