package csbase.client.applications.algorithmsmanager.report.implementations;

import java.util.HashMap;
import java.util.Map;

import csbase.client.applications.Application;
import csbase.client.applications.algorithmsmanager.report.core.ISubjectFactory;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;

/**
 * Fbrica de objetos para os testes do Gerente de Algoritmos.
 */
public class AlgorithmManagerSubjectFactory implements ISubjectFactory {

  /**
   * Fontes de dados para o testes mapeados por tipo.
   */
  private final Map<Class<?>, Iterable<?>> sources;

  /**
   * Aplicao.
   */
  private final Application app;

  /**
   * Construtor.
   *
   * @param app Aplicao para disparar as tasks.
   */
  public AlgorithmManagerSubjectFactory(Application app) {
    this.sources = new HashMap<>();
    this.app = app;
  }

  /**
   * Adiciona uma nova fonte de dados.
   *
   * @param clazz a classe do objeto.
   * @param source a fonte do objeto.
   * @param <T> o tipo do objeto.
   */
  private <T> void addSource(Class<T> clazz, Iterable<T> source) {
    sources.put(clazz, source);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  @SuppressWarnings("unchecked")
  public <T> Iterable<T> createSubject(ITest<T> test) {
    Class<T> subjectType = test.getSubjectClass();
    Iterable<?> subject = sources.get(subjectType);
    if (subject == null) {
      if (subjectType.equals(AlgorithmInfo.class)) {
        addSource(AlgorithmInfo.class, new AlgorithmInfoSource(app));
      }
      else if (subjectType.equals(FlowAlgorithmConfigurator.class)) {
        addSource(FlowAlgorithmConfigurator.class, new FlowConfiguratorSource(
          app));
      }
      subject = sources.get(subjectType);
    }
    return (Iterable<T>) subject;
  }

}
