package csbase.client.applications.algorithmsmanager.report.implementations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.AlgorithmConfigurator.ConfiguratorType;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.remote.ClientRemoteLocator;

/**
 * Cria e armazena um conjunto de FlowConfigurator para ser usado como fonte de
 * dadops de um teste. Cria utilizando uma TASK REMOTA.
 *
 * @author Tecgraf/PUC-Rio
 */
public class FlowConfiguratorSource implements
Iterable<FlowAlgorithmConfigurator> {

  /** Lista de dados */
  private final List<FlowAlgorithmConfigurator> list;

  /**
   * Construtor
   * 
   * @param app Aplicao para disparar a task.
   */
  public FlowConfiguratorSource(Application app) {
    RemoteTask<List<FlowAlgorithmConfigurator>> task =
      new RemoteTask<List<FlowAlgorithmConfigurator>>() {

      @Override
      protected void performTask() throws Exception {
        AlgorithmInfo[] infos =
            ClientRemoteLocator.algorithmService.getAllInfo();
          List<FlowAlgorithmConfigurator> flows = new ArrayList<>();

          int i = 0;
        int n = infos.length;
        for (AlgorithmInfo info : infos) {
          setProgressStatus(i * 100 / n);
          if (info != null && info.getLastVersion()!=null &&
        		  info.getLastVersion().getType() == ConfiguratorType.FLOW) {
            try {
              FlowAlgorithmConfigurator configurator =
                (FlowAlgorithmConfigurator) ClientRemoteLocator.algorithmService
                .createAlgorithmConfigurator(info.getName(), info
                  .getLastVersion().getId());

              flows.add(configurator);

              setResult(flows);
            }
            catch (Exception e) {
              //ignora
            }
          }
          i++;
        }
      }
    };

    task.execute(app.getApplicationFrame(), app.getClassString(getClass(),
      "task.title"), app.getClassString(getClass(), "task.description"), true,
      false);

    if (task.getStatus()) {
      list = task.getResult();
    }
    else {
      list = new ArrayList<>();
    }
  }

  /** {@inheritDoc} */
  @Override
  public Iterator<FlowAlgorithmConfigurator> iterator() {
    return list.iterator();
  }
}