package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Essa classe implementa um n de verso da rvore de verses do algoritmo
 * selecionado.
 * 
 */
public class VersionTreeNode extends VersionNode implements
  VersionNodeInterface {

  /**
   * Constri o n de verso do algoritmo.
   * 
   * @param tree rvore que contm esse n
   * @param algorithmVersionInfo informaes da verso do algoritmo
   */
  public VersionTreeNode(VersionTree tree,
    AlgorithmVersionInfo algorithmVersionInfo) {
    super(tree, algorithmVersionInfo);
  }

  @Override
  public int compare(AlgorithmVersionInfo node) {
    return getNode().compareTo(node);
  }

  @Override
  public AlgorithmVersionInfo getNode() {
    return (AlgorithmVersionInfo) getUserObject();
  }

  @Override
  public boolean isRootNode() {
    return false;
  }

  @Override
  public AlgorithmVersionId getId() {
    return getNode().getId();
  }

}
