package csbase.client.applications.commandsmonitor.models;

import java.util.List;

/**
 * Informaes de uma aba de tabelas de comandos.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class TablesTabDTO {

  /** Identificador nico da aba. */
  private final String id;
  /** Lista ordenada de identificadores nicos das tabelas. */
  private final List<String> tablesId;
  
  /**
   * Construtor.
   * 
   * @param id Identificador nico da aba.
   * @param tablesId Lista ordenada de identificadores nicos das tabelas.
   */
  public TablesTabDTO(String id, List<String> tablesId) {
    this.id = id;
    this.tablesId = tablesId;
  }

  /**
   * Obtm o identificador nico desta aba.
   * 
   * @return o identificador nico desta aba.
   */
  public String getId() {
    return id;
  }

  /**
   * Obtm uma lista ordenada de identificadores nicos das tabelas.
   * 
   * @return lista ordenada de identificadores nicos das tabelas.
   */
  public List<String> getTablesId() {
    return tablesId;
  }    
}
