package csbase.client.preferences.types;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.editors.PVStringEditor;
import csbase.client.preferences.util.PreferenceBundle;

/**
 * Preferncia que encapsula um valor {@link String}. Este valor deve ser usado
 * da seguinte forma:<br/>
 * 
 * \@Value(type=PVString.class, defaultValue="abc")
 * 
 * @see PreferenceValue PreferenceCategory PreferencePolicy
 * 
 * @author Tecgraf
 */
public class PVString extends PreferenceValue<String> {

  /**
   * Construtor usado na instanciao desta classe por reflexo.
   * 
   * @param name nome da preferncia que possui este valor.
   * @param value valor da preferncia.
   * @param defaultValue valor default da preferncia.
   * @param policy poltica de visibilidade do valor.
   * @param preferenceBundle objeto responsvel pela internacionalizao.
   */
  public PVString(PreferenceDefinition name, String value, String defaultValue,
    PreferencePolicy policy, PreferenceBundle preferenceBundle) {
    super(name, value, defaultValue, policy, preferenceBundle);

    setPreferenceEditorClass(PVStringEditor.class);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClassName() {
    return getClass().getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toValue(String value) {
    return value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return getValue().toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PreferenceValue<String> clone() {
    return new PVString(name, this.toString(), defaultValue, policy,
      preferenceBundle);
  }
}
