package csbase.client.project;

import java.util.EventListener;

import javax.swing.event.TreeModelEvent;

/**
 * Representa um ouvinte que ser notificado quando a estrutura de uma {@link
 * csbase.client.project.ProjectTree} for mudada. Obs: Esse ouvinte foi criado
 * com a inteno de contornar duas caractersticas da {@link
 * javax.swing.JTree}, quando acontece uma mudana na estrutura de seu modelo:
 * 
 * <ol>
 * <li>
 * Fechar (colapsar) todos os ns expandidos.
 * </li>
 * <li>
 * Limpar a lista de ns selecionados.
 * </li>
 * </ol>
 * 
 *
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 * @version $Revision: 35317 $
 */
public interface ProjectTreeStructureListener extends EventListener {
  /**
   * Invocado antes de a estrutura ser mudada.
   *
   * @param event Objeto que contm os dados sobre o evento que foi gerado.
   */
  public void treeWillChange(TreeModelEvent event);

  /**
   * Invocado depois de a estrutura ter sido mudada.
   *
   * @param event Objeto que contm os dados sobre o evento que foi gerado.
   */
  public void treeWasChanged(TreeModelEvent event);
}
