/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.core;

import csbase.client.applications.algorithmsmanager.report.core.BasicTestDialog;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.gui.GBC;

public class TestSelectionDialog
extends BasicTestDialog {
    private final List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
    private boolean clickedOk = false;

    public TestSelectionDialog(List<ITest<?>> tests, Locale locale, Window parentWindow) {
        super(locale, parentWindow);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(this.getString("title"));
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        int y = 0;
        for (ITest<?> test : tests) {
            JCheckBox checkBox = new JCheckBox(test.getName());
            this.checkBoxes.add(checkBox);
            checkBox.setToolTipText(test.getDescription());
            checkBox.setSelected(true);
            checkBoxPanel.add((Component)checkBox, new GBC(0, y).insets(6, 11, 6, 11).horizontal());
            ++y;
        }
        JButton okButton = new JButton(this.getString("ok.button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSelectionDialog.this.clickedOk = true;
                TestSelectionDialog.this.dispose();
            }
        });
        JButton cancelButton = new JButton(this.getString("cancel.button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSelectionDialog.this.dispose();
            }
        });
        JScrollPane scroll = new JScrollPane(checkBoxPanel);
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)cancelButton, new GBC(0, 0).none().east().insets(11, 11, 11, 11));
        buttonsPanel.add((Component)okButton, new GBC(1, 0).none().east().insets(11, 11, 11, 11));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)scroll, new GBC(0, 0).both());
        this.getContentPane().add((Component)buttonsPanel, new GBC(0, 1).horizontal());
        this.pack();
        this.setLocationRelativeTo(parentWindow);
    }

    public List<Boolean> getSelection() {
        ArrayList<Boolean> selection = new ArrayList<Boolean>();
        if (!this.clickedOk) {
            return null;
        }
        for (JCheckBox checkBox : this.checkBoxes) {
            if (this.clickedOk && checkBox.isSelected()) {
                selection.add(true);
                continue;
            }
            selection.add(false);
        }
        return selection;
    }
}

