/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.implementations;

import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.remote.ClientRemoteLocator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleConfiguratorSource
implements Iterable<SimpleAlgorithmConfigurator> {
    private final List<SimpleAlgorithmConfigurator> list;

    public SimpleConfiguratorSource(Application app) {
        RemoteTask<List<SimpleAlgorithmConfigurator>> task = new RemoteTask<List<SimpleAlgorithmConfigurator>>(){

            protected void performTask() throws Exception {
                AlgorithmInfo[] infos = ClientRemoteLocator.algorithmService.getAllInfo();
                ArrayList<SimpleAlgorithmConfigurator> configurators = new ArrayList<SimpleAlgorithmConfigurator>();
                int i = 0;
                int n = infos.length;
                for (AlgorithmInfo info : infos) {
                    this.setProgressStatus(i * 100 / n);
                    if (info != null && info.getLastVersion() != null && info.getLastVersion().getType() == AlgorithmConfigurator.ConfiguratorType.SIMPLE) {
                        try {
                            SimpleAlgorithmConfigurator configurator = (SimpleAlgorithmConfigurator)ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(info.getName(), info.getLastVersion().getId());
                            configurators.add(configurator);
                            this.setResult(configurators);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        };
        task.execute(app.getApplicationFrame(), app.getClassString(this.getClass(), "task.title"), app.getClassString(this.getClass(), "task.description"), true, false);
        this.list = task.getStatus() ? (List<Object>)task.getResult() : new ArrayList<SimpleAlgorithmConfigurator>();
    }

    @Override
    public Iterator<SimpleAlgorithmConfigurator> iterator() {
        return this.list.iterator();
    }
}

