/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.monitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.JComponent;

public class DiskUsagePanel
extends JComponent {
    private double usedPerc;
    private double freePerc;
    private static final int HEIGHT = 25;

    public DiskUsagePanel(double used, double free) {
        this.usedPerc = used / (used + free);
        this.freePerc = free / (used + free);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), 46);
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), 46);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.getWidth(), 46);
    }

    @Override
    public void paint(Graphics g) {
        super.paintComponent(g);
        int usedWidth = new Double((double)this.getWidth() * this.usedPerc).intValue();
        int freeWidth = new Double((double)this.getWidth() * this.freePerc).intValue();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fillRect(0, 0, usedWidth, 25);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0 + usedWidth, 0, freeWidth, 25);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, this.getWidth() - 1, 25);
        g2d.setColor(Color.BLACK);
        this.drawCenteredTextAtPosition(NumberFormat.getPercentInstance().format(this.usedPerc), g2d, usedWidth / 2, 12);
        this.drawCenteredTextAtPosition(NumberFormat.getPercentInstance().format(this.freePerc), g2d, usedWidth + (this.getWidth() - usedWidth) / 2, 12);
        g2d.dispose();
    }

    private void drawCenteredTextAtPosition(String str, Graphics g, int x, int y) {
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D bounds = metrics.getStringBounds(str, g);
        int new_x = (int)((double)x - bounds.getCenterX());
        int new_y = (int)((double)y - bounds.getCenterY());
        g.drawString(str, new_x, new_y);
    }
}

