/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/**
 * Coluna de uma tabela de comandos.
 * 
 * @param <R> Tipo do objeto representado pela linha da tabela.
 * 
 * @author Tecgraf / PUC-Rio
 */
public interface IColumn<R> {

  /**
   * Obtm a classe da propriedade de <R> que  representada por esta coluna.
   * 
   * @return a classe da propriedade de <R> que  representada por esta coluna.
   */
  public abstract Class<?> getColumnClass();

  /**
   * Obtm o nome da coluna.
   * 
   * @return o nome da coluna.
   */
  public abstract String getColumnName();

  /**
   * Obtm o renderizador de clulas para esta coluna.
   * 
   * @return o renderizador de clulas para esta coluna. Caso seja nulo, ser
   *         utilizado o renderizador padro da tabela.
   */
  public abstract TableCellRenderer createTableCellRenderer();

  /**
   * Obtm o editor de clulas para esta coluna.
   * 
   * @return o editor de clulas para esta coluna. Caso seja nulo, ser
   *         utilizado o editor padro da tabela.
   */
  public abstract TableCellEditor createTableCellEditor();

  /**
   * Obtm <tt>true</tt> se a coluna for editvel.
   * 
   * @return true se a coluna for editvel.
   */
  public abstract boolean isColumnEditable();

  /**
   * Altera o valor da propriedade do objeto, representada por esta coluna.
   * 
   * @param obj objeto representado por uma linha da tabela, ao qual se deseja
   *        obter atribuir valor a propriedade representada por esta coluna.
   * 
   * @param value o novo valor da propriedade do comando, representada por esta
   *        coluna.
   */
  public abstract void setValue(R obj, Object value);

  /**
   * Obtm o valor da propriedade do objeto, representada por esta coluna.
   * 
   * @param obj objeto representado por uma linha da tabela, do qual se deseja
   *        obter a propriedade representada por esta coluna.
   * 
   * @return o valor da propriedade do comando, representada por esta coluna.
   */
  public abstract Object getValue(R obj);
}