/*
 * $Id$
 */

package csbase.client.applications.desktoplauncher;

import java.net.URL;
import java.util.Locale;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.Client;
import csbase.client.externalresources.ExternalResources;
import csbase.client.openbus.OpenBusAccessPoint;
import csbase.client.openbus.OpenBusTask;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.OpenURLServiceInterface;

/**
 * Task de conexo ao Openbus.
 * 
 * @author Tecgraf/PUC-Rio
 */
final class DesktopLauncherTask extends OpenBusTask<Void> {

  /**
   * Aplicao.
   */
  final private DesktopLauncher application;

  /**
   * Label do sistema a ser disparado.
   */
  private String systemLabel;

  /**
   * {@inheritDoc}
   */
  @Override
  final protected String getString(final String key) {
    final String prefix = getClass().getSimpleName();
    return application.getString(prefix + "." + key);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    final OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
    oap.init();
    oap.initSession();

    final OpenBusLoginToken token = oap.getLoginToken();
    final Locale locale = LNG.getLocale();
    final OpenURLServiceInterface service = ClientRemoteLocator.openURLService;
    final Client client = Client.getInstance();
    final String myClientId = client.getClientInstanceId();

    final String sonId = application.getSonId();
    final boolean startVisible = application.isChildDesktopInitiallyVisible();
    final URL url =
      service.getSystemURL(locale, token, systemLabel, myClientId, sonId,
        startVisible);
    if (url == null) {
      final String key = "null.url.error";
      final String err = getString(key);
      throw new Exception(err);
    }

    final ExternalResources externalResources = ExternalResources.getInstance();
    final boolean launched = externalResources.showDocument(url);
    if (!launched) {
      final String key = "launch.error";
      final String err = getString(key);
      throw new Exception(err);
    }
  }

  /**
   * Construtor
   * 
   * @param application a aplicao.
   * @param systemLabel label do sistema a ser disparado.
   */
  DesktopLauncherTask(final DesktopLauncher application,
    final String systemLabel) {
    this.systemLabel = systemLabel;
    this.application = application;
  }
}
