/**
 * 
 */
package csbase.client.applications.projectsmanager.panels.renderers;

import java.awt.Color;
import java.awt.Component;
import java.util.Date;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.logic.Utilities;

/**
 * Renderer das colunas de datas.
 * 
 * @author Tecgraf/PUC-Rio
 * 
 */
public class TableDateRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    final Component component =
      super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
        row, column);

    if (value == null) {
      return component;
    }

    final JLabel label = (JLabel) component;
    final Date date = (Date) value;
    label.setHorizontalAlignment(SwingConstants.CENTER);

    final long time = date.getTime();
    if (time == 0L) {
      label.setText("-");
      label.setForeground(Color.gray);
      final String tooltipTag = "TableDateRenderer.no.time.tooltip";
      final String tooltip = ProjectsManagerUI.getString(tooltipTag);
      label.setToolTipText(tooltip);
    }
    else {
      label.setForeground(Color.black);
      label.setIcon(null);
      final String text = Utilities.getFormattedDate(time);
      label.setText(text);
    }
    return label;
  }
}
