package csbase.client.preferences.util;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferencePolicy;

/**
 * Dilogo genrico que permite que o usurio edite as preferncias de uma
 * categoria.
 * 
 * @author Tecgraf
 */
public class PreferencesEditorDialog extends JDialog {

  /** Boto de confirmao. */
  private JButton ok;

  /** Boto de cancelar. */
  private JButton cancel;

  /** Categoria de preferncias a ser editada. */
  private PreferenceCategory pc;

  /**
   * Construtor padro.
   * 
   * @param parent janela pai deste dilogo.
   * @param title ttulo do dilogo.
   * @param pc categoria a ser editada.
   * @param isResizible flag que define se o dilogo pode ser redimensionado.
   * @param w largura do dilogo.
   * @param h altura do dilogo.
   */
  public PreferencesEditorDialog(Window parent, String title,
    PreferenceCategory pc, boolean isResizible, int w, int h) {
    super(parent, title, ModalityType.DOCUMENT_MODAL);
    if (pc == null) {
      throw new IllegalArgumentException("pc no pode ser nulo.");
    }
    setLayout(new GridBagLayout());

    this.pc = pc;
    this.ok = new JButton("Ok");
    this.cancel = new JButton(LNG.get("UTIL_CANCEL"));
    GUIUtils.matchPreferredSizes(new JComponent[] { this.ok, this.cancel });

    setButtonsAction();

    buildInterface();
    setLocationRelativeTo(getOwner());
    setMinimumSize(new Dimension(w, h));

    setResizable(isResizible);
    pack();
  }

  /** Constroi a interface do dilogo. */
  private void buildInterface() {
    JPanel panel = PreferencesUtil.createPreferencePanel(pc, false);
    JPanel buttonsPanel = createButtonsPanel();

    add(panel, new GBC(0, 0).horizontal());
    add(buttonsPanel, new GBC(0, 1).horizontal());
  }

  /**
   * Cria o painel que contm os botes.
   * 
   * @return painel com os botes.
   */
  private JPanel createButtonsPanel() {
    JPanel buttonsPanel = new JPanel(new GridBagLayout());
    buttonsPanel.add(ok, new GBC(0, 0).none().top(5).left(10).right(10));
    buttonsPanel.add(cancel, new GBC(1, 0).none().top(5).left(10).right(10));
    return buttonsPanel;
  }

  /** Adiciona aes para os botes. */
  private void setButtonsAction() {
    ok.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        for (PreferenceValue<?> pv : pc.getPreferences(
          PreferencePolicy.READ_ONLY, PreferencePolicy.READ_WRITE)) {
          PreferenceEditor<?> editor = pv.getEditor();
          editor.commit();
          PreferencesEditorDialog.this.setVisible(false);
        }
        PreferenceManager.getInstance().savePreferences(
          PreferencesEditorDialog.this);
      }
    });

    cancel.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        PreferencesEditorDialog.this.setVisible(false);
      }
    });
  }

}
