/*
 * Created on Jun 17, 2004
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.project.FilePropertiesDialog;
import csbase.client.project.ProjectFileContainer;

/**
 * Ao que abre dilogo de "visualizao de propriedades" de arquivos da rvore
 * de projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CommonFilePropertiesShowAction extends CommonProjectAction {

  /**
   * Construtor.
   * 
   * @param container o container
   */
  public CommonFilePropertiesShowAction(ProjectFileContainer container) {
    super(container);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    FilePropertiesDialog.show(getWindow(), getProject(), getSelectedFile());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_FILE_SEE_PROPERTIES");
  }

}
