/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.validation.ValidationTranslator;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.SimpleParameterListener;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;

public abstract class SimpleParameterView<V>
extends ParameterView<SimpleParameter<V>> {
    private static final ComponentAlignment DEFAULT_ALIGNMENT = ComponentAlignment.HORIZONTAL_LABEL_FIRST;
    private JLabel label;
    private JComponent component;

    protected SimpleParameterView(SimpleParameter<V> simpleParameter, ParameterView.Mode mode, Object ... componentArgs) {
        super(simpleParameter, mode);
        this.component = this.createComponent(componentArgs);
        ((SimpleParameter)this.getParameter()).addSimpleParameterListener(new SimpleParameterListener<V>(){

            public void capabilityWasChanged(SimpleParameter<V> parameter) {
                SimpleParameterView.this.updateCapabilityView();
            }

            public void defaultValueWasChanged(SimpleParameter<V> parameter) {
            }

            public void valueWasChanged(SimpleParameter<V> parameter) {
                SimpleParameterView.this.updateViewContents();
            }

            public void visibilityWasChanged(SimpleParameter<V> parameter) {
                if (SimpleParameterView.this.getMode() == ParameterView.Mode.CONFIGURATION) {
                    SimpleParameterView.this.updateVisibilyView();
                }
            }

            public void labelWasChanged(SimpleParameter<V> parameter) {
                SimpleParameterView.this.updateLabel();
            }
        });
        this.label = new JLabel();
        this.updateLabel();
    }

    public boolean isNullable() {
        return true;
    }

    private void updateLabel() {
        String paramLabel = ((SimpleParameter)this.getParameter()).getLabel();
        this.label.setText(paramLabel);
        if (!((SimpleParameter)this.getParameter()).isOptional() && this.isNullable() && !paramLabel.trim().isEmpty()) {
            this.label.setHorizontalTextPosition(2);
            this.label.setIcon(ApplicationImages.ICON_MANDATORY_7);
            this.label.setIconTextGap(1);
        }
        String name = ((SimpleParameter)this.getParameter()).getName();
        String toolTipText = MessageFormat.format("{0} ({1})", paramLabel, name);
        this.label.setToolTipText(toolTipText);
    }

    public final JComponent[] getComponents() {
        ComponentAlignment alignment = this.getComponentAlignment();
        switch (alignment) {
            case VERTICAL: {
                JPanel verticalPanel = new JPanel(new BorderLayout(0, 5));
                verticalPanel.add((Component)this.getLabel(), "North");
                verticalPanel.add((Component)this.getComponent(), "Center");
                return new JComponent[]{verticalPanel};
            }
            case HORIZONTAL_LABEL_LAST: {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)this.getComponent(), "West");
                panel.add((Component)this.getLabel(), "Center");
                return new JComponent[]{panel};
            }
        }
        return new JComponent[]{this.label, this.getComponent()};
    }

    protected final ComponentAlignment getComponentAlignment() {
        try {
            ConfigurationManager manager = ConfigurationManager.getInstance();
            Configuration configuration = manager.getConfiguration(SimpleParameterView.class);
            String propName = this.getClass().getName();
            return (ComponentAlignment)configuration.getOptionalEnumerationProperty(propName, ComponentAlignment.class, (Enum)DEFAULT_ALIGNMENT);
        }
        catch (ConfigurationManagerException e) {
            e.printStackTrace();
            return DEFAULT_ALIGNMENT;
        }
    }

    public final JLabel getLabel() {
        return this.label;
    }

    @Override
    public boolean highlightValidationResult(ViewValidationResult result) {
        if (!result.isWellSucceded()) {
            String message = ValidationTranslator.translateMessage((Validation)result);
            this.showErrorMessage(message);
        }
        return true;
    }

    @Override
    public ViewValidationResult validate(ValidationMode mode) throws RemoteException {
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        SimpleParameter parameter = (SimpleParameter)this.getParameter();
        Object projectId = project == null ? null : project.getId();
        Object userId = User.getLoggedUser().getId();
        ValidationContext context = new ValidationContext(mode, projectId, userId);
        Validation validate = parameter.validate(context);
        ViewValidationResult result = new ViewValidationResult(validate, (ViewValidator)this);
        return result;
    }

    public final void clearError() {
        this.label.setForeground(Color.BLACK);
    }

    public Window getWindow() {
        JComponent paramComponent = this.getComponent();
        return null == paramComponent ? null : SwingUtilities.windowForComponent(paramComponent);
    }

    public JComponent getComponent() {
        return this.component;
    }

    protected abstract JComponent createConfigurationComponent(Object ... var1);

    protected abstract JComponent createReportComponent(Object ... var1);

    public final void highlightError() {
        this.label.setForeground(Color.RED);
    }

    @Override
    protected final boolean isVisible() {
        return this.label.isVisible();
    }

    protected void setEnabled(boolean isEnabled) {
        if (null != this.component) {
            this.component.setEnabled(isEnabled);
        }
    }

    @Override
    protected final void setVisible(boolean isVisible) {
        this.label.setVisible(isVisible);
        if (null != this.getComponent()) {
            this.getComponent().setVisible(isVisible);
        }
    }

    protected final void showErrorMessage(String errorMessage) {
        this.highlightError();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(this.getWindow(), errorMessage, "Erro no configurador de par\u00e2metros", 0);
        this.getComponent().requestFocus();
        this.clearError();
    }

    protected final void updateCapabilityView() {
        this.label.setEnabled(((SimpleParameter)this.getParameter()).isEnabled());
        this.setEnabled(((SimpleParameter)this.getParameter()).isEnabled());
    }

    protected abstract void updateViewContents();

    private JComponent createComponent(Object ... componentArgs) {
        switch (this.getMode()) {
            case REPORT: {
                return this.createReportComponent(componentArgs);
            }
        }
        return this.createConfigurationComponent(componentArgs);
    }

    private static enum ComponentAlignment {
        VERTICAL,
        HORIZONTAL_LABEL_FIRST,
        HORIZONTAL_LABEL_LAST;

    }
}

