/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectInfoData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.FillProjectsTableAdminTask;
import csbase.client.applications.projectsmanager.proxy.FillProjectsTableUserTask;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.UserProjectInfo;
import java.awt.Component;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class FillProjectsTableAction
extends ProjectsManagerAction {
    private final boolean adminMode;
    private final boolean loadOccupiedSpace;

    public FillProjectsTableAction(ProjectsManager projectsManager, boolean adminMode, boolean loadOccupiedSpace) {
        super(projectsManager);
        this.adminMode = adminMode;
        this.loadOccupiedSpace = loadOccupiedSpace;
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        projectsManager.clearAllProjects();
        projectsManager.clearTable();
        projectsManager.clearFilters();
        ProjectsManagerTask fptt = this.adminMode ? new FillProjectsTableAdminTask(projectsManager, this.loadOccupiedSpace) : new FillProjectsTableUserTask(projectsManager, this.loadOccupiedSpace);
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        fptt.execute(appFrame, this.getString("FillProjectsTableAction.title"), this.getString("FillProjectsTableAction.message"));
        if (fptt.wasCancelled()) {
            fptt.showError(this.getString("FillProjectsTableAction.cancelled.message"));
            return;
        }
        if (!fptt.getStatus()) {
            throw fptt.getError();
        }
        ProjectInfoData pid = (ProjectInfoData)fptt.getResult();
        List<ProjectsManagerData> projects = pid.getProjectsData();
        List<UserProjectInfo> failedProjects = pid.getFailedProjectsData();
        if (projects == null) {
            String errMsg = this.getString("FillProjectsTableAction.reading.error.message");
            String errTitle = this.getString("FillProjectsTableAction.reading.error.title");
            StandardDialogs.showErrorDialog((Component)appFrame, (String)errTitle, (String)errMsg);
            return;
        }
        String message = this.getString("FillProjectsTableAction.project.file.error.message");
        if (failedProjects.size() > 0) {
            String conclusionMessage = this.getString("FillProjectsTableAction.project.loading.error.title");
            StatusDialog.showLoadingFailureDialog(projectsManager, message, failedProjects, conclusionMessage);
        }
        for (ProjectsManagerData prj : projects) {
            projectsManager.addProject(prj);
        }
        projectsManager.refreshProjectsTable();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_REFRESH_16;
    }
}

