/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.DataPropertiesListener;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class DataBindingPanel
extends AbstractSimpleApplicationPanel<AlgorithmsManager> {
    private ContainerSelection<DataInterface> containerSelection;
    private SortedSet<DataInterface> availableData;
    private SortedSet<DataInterface> previousSelectedData;
    private String description;
    private List<DataPropertiesListener> bindListeners;

    DataBindingPanel(AlgorithmsManager application, SortedSet<DataInterface> availableData, SortedSet<DataInterface> selectedData, String description) {
        super(application);
        this.availableData = availableData;
        this.previousSelectedData = selectedData;
        this.description = description;
        this.bindListeners = new Vector<DataPropertiesListener>();
        this.buildPanel();
    }

    @Override
    protected void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        JLabel descriptionLabel = new JLabel(this.description);
        this.add((Component)descriptionLabel, new GBC(0, 0).horizontal().west().insets(5, 5, 5, 5));
        this.add((Component)this.getDataSelectionPanel(this.getAvailableItems(), this.previousSelectedData), new GBC(0, 1).both().west().insets(5, 5, 5, 5));
    }

    private JPanel getDataSelectionPanel(SortedSet<DataInterface> availableItems, SortedSet<DataInterface> selectedItems) {
        MyObjectTableProvider selectableProvider = new MyObjectTableProvider(this.getString("DataBindingPanel.available_items"));
        MyObjectTableProvider selectedProvider = new MyObjectTableProvider(this.getString("DataBindingPanel.selected_items"));
        this.containerSelection = new ContainerSelection((ObjectTableProvider)selectableProvider, (ObjectTableProvider)selectedProvider, true, false);
        this.containerSelection.loadItems(availableItems, selectedItems);
        this.containerSelection.adjustTableColumns();
        this.containerSelection.addContainerSelectionListener(new ContainerSelectionListener(){

            public void containerChanged() {
                DataBindingPanel.this.notifyListeners();
            }
        });
        return this.containerSelection.getPanel();
    }

    private SortedSet<DataInterface> getAvailableItems() {
        return this.availableData;
    }

    public List<DataInterface> getSelectedItems() {
        return this.containerSelection.getSelectedItems();
    }

    public void updateItems(SortedSet<DataInterface> availableItems, SortedSet<DataInterface> selectedItems) {
        if (this.containerSelection != null) {
            this.containerSelection.loadItems(availableItems, selectedItems);
            this.containerSelection.adjustTableColumns();
        }
        this.revalidate();
    }

    protected void notifyListeners() {
        for (DataPropertiesListener bindListener : this.bindListeners) {
            bindListener.propertiesChanged(true);
        }
    }

    public void addDataBindListener(DataPropertiesListener listener) {
        this.bindListeners.add(listener);
    }

    private final class MyObjectTableProvider
    extends DefaultObjectTableProvider {
        private String columnName;

        MyObjectTableProvider(String columnName) {
            this.columnName = columnName;
        }

        public String[] getColumnNames() {
            return new String[]{this.columnName};
        }

        public Class<?>[] getColumnClasses() {
            return new Class[]{String.class};
        }

        public Object[] getCellValues(Object row) {
            DataInterface item = (DataInterface)row;
            return new Object[]{item.getFullName()};
        }
    }
}

