package csbase.client.applications.algorithmsmanager.dialogs;

import java.awt.BorderLayout;
import java.util.Vector;

import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;

import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.util.gui.AlgorithmFilterParamPanel;
import csbase.client.util.gui.AlgorithmFilterParamPanelListener;
import csbase.client.util.gui.AlgorithmInfoFilterOperator;
import csbase.client.util.gui.FilterableComboModel;
import csbase.logic.algorithms.AlgorithmInfo;

/**
 * Componente Jlist filtrvel pelo toString dos itens: este componente possui um
 * campo de texto onde o usurio digita o prefixo do rtulo que ele deseja e uma
 * JList que exibe apenas os nomes que possuem aquele prefixo.
 *
 * @author Tecgraf/PUC-Rio
 */

public final class FilterableListPanel extends JPanel {

  /** O painel de filtragem */
  private AlgorithmFilterParamPanel filterParamPanel;

  /** A JList. */
  private JList jlist;

  private AlgorithmItemFilter filter;

  /**
   * Cria o painel.
   *
   * @param list A lista original de elementos.
   */
  public FilterableListPanel(Vector<AlgorithmListItem> list) {

    filter = new AlgorithmItemFilter();

    this.jlist = new JList();
    Vector<Object> oList = new Vector(list);
    FilterableComboModel model = new FilterableComboModel(oList, filter);
    jlist.setModel(model);

    filterParamPanel = new AlgorithmFilterParamPanel();
    filterParamPanel.addListener(new AlgorithmFilterParamPanelListener() {

      @Override
      public void panelChanged(boolean ignoreCase, boolean useRegex,
        boolean showSimple, boolean showFlow, String text) {
        AlgorithmInfoFilterOperator operator = new AlgorithmInfoFilterOperator(
          ignoreCase, useRegex, showSimple, showFlow, text);
        filter.setParamters(operator);
        FilterableComboModel model = (FilterableComboModel) jlist.getModel();
        model.filter();
      }
    });

    setLayout(new BorderLayout());
    add(filterParamPanel, BorderLayout.NORTH);
    add(new JScrollPane(jlist, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
      ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS), BorderLayout.CENTER);
    filterParamPanel.updateState();
  }

  /**
   * Obtm a Jlist.
   *
   * @return A jlist.
   */
  public JList getList() {
    return jlist;
  }

  /**
   * Filtro que indica, baseado no contedo do painel, se o Algoritmo deve ser
   * mostrado ou no
   *
   *
   * @author Tecgraf/PUC-Rio
   */
  private class AlgorithmItemFilter extends FilterableComboModel.Filter {

    /** O operador que faz a filtragem em si */
    AlgorithmInfoFilterOperator operator;

    /**
     * Define o operador
     * 
     * @param operator o operador do filtro.
     */
    public void setParamters(AlgorithmInfoFilterOperator operator) {
      this.operator = operator;
    }

    /** {@inheritDoc} */
    @Override
    public boolean accept(Object object) {
      AlgorithmInfo info = ((AlgorithmListItem) object).getItem();
      return operator.accept(info);
    }

    /**
     * Indica se tem algo para usar de filtro
     *
     * @return se deve filtrar ou no
     */
    @Override
    public boolean isEnabled() {
      return operator != null;
    }
  };
}