/*
 * $Id:$
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.List;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLElement;
import tecgraf.javautils.xml.XMLElementInterface;
import csbase.client.applications.commandsmonitor.models.CommandsFilterDTO;
import csbase.client.applications.commandsmonitor.models.ExpressionDTO;
import csbase.logic.CommandStatus;

/**
 * Elemento Filtro.
 * 
 * @author Tecgraf
 */
public class FilterElement extends XMLElement {

  /**
   * Consulta o nome da tag
   * 
   * @return tag
   */
  public static final String getTagName() {
    return "filter";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {

    // Pega o id do filtro.
    String id = getAttributeStrValue("id");

    // Pega as informaes quanto ao status dos comandos a que o filtro tem interesse.
    /*
     * Pega o modo de funcionamento do filtro. Se in='true', ento o filtro ir
     * funcionar para comandos em um dos estados passados, caso contrrio, ele
     * ir funcionar para todos os estados com exceo dos passados.
     */
    boolean statuses_included =
      hasAttribute("in") ? getAttributeBooleanValue("in") : true;
    // Pega os estados a serem filtrados.
    CommandStatus[] statuses;
    String stringStatuses = getAttributeStrValue("statuses");
    if (-1 < stringStatuses.indexOf("all")) {
      statuses = CommandStatus.values();
    }
    else {
      String[] spplited = stringStatuses.split("\\|");
      statuses = new CommandStatus[spplited.length];
      for (int inx = 0; inx < spplited.length; inx++) {
        String sstatus = spplited[inx].toUpperCase().trim();
        if ("".equals(sstatus)) {
          continue;
        }

        statuses[inx] = CommandStatus.valueOf(sstatus);
      }
    }

    ExpressionDTO expressionInfo = null;
    // Pega a expresso do filtro.
    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);
    XMLElementInterface expressionElement =
      iterator.next(ExpressionElement.getTagName());
    if (null != expressionElement) {
      expressionInfo = (ExpressionDTO) expressionElement.getAppObject();
    }

    setAppObject(new CommandsFilterDTO(id, statuses_included, statuses,
      expressionInfo));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }
}
