/*
 * $Id:$
 */

package csbase.client.applications.filetransferclient.panels.queuepanel;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.logic.filetransferservice.FileTransferRequestType;

/**
 * Modelo de exibio da tabela de requisies em andamento com base em uma
 * lista interna oriunda do FtpProxy
 * 
 * @author Tecgraf/PUC-Rio
 */
class QueueTableModel extends AbstractTableModel {

  /**
   * Texto das colunas.
   */
  final private String[] colNames;

  /**
   * Lista de requisies;
   */
  private List<FileTransferRequest> list;

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnCount() {
    return colNames.length;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowCount() {
    if (list == null) {
      return 0;
    }
    return list.size();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValueAt(final int row, final int column) {
    if (list == null) {
      return null;
    }
    final FileTransferRequest request = list.get(row);
    if (column == 0) {
      final FileTransferRequestStatus status = request.getStatus();
      return status;
    }
    else if (column == 1) {
      final FileTransferRequestType type = request.getType();
      return type;
    }
    else if (column == 2) {
      final FileTransferConnection connection = request.getConnection();
      final Object userId = connection.getUserId();
      try {
        final User user = User.getUser(userId);
        return user;
      }
      catch (Exception e) {
        return null;
      }
    }
    else if (column == 3) {
      return request.getPercentage();
    }
    else if (column == 4) {
      final String[] localFilePath = request.getLocalFilePath();
      String pth = "";
      for (String s : localFilePath) {
        pth = pth + "/" + s;
      }
      return pth;
    }
    else if (column == 5) {
      return request.getTotalBytesSize();
    }
    else if (column == 6) {
      return request.getGlobalTransferRateKBytesSec();
    }
    else if (column == 7) {
      return request.getQueueTime();
    }
    else if (column == 8) {
      return request.getStartTime();
    }
    else if (column == 9) {
      return request.getEndTime();
    }
    else if (column == 10) {
      return request.getErrorMessage();
    }

    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName(final int col) {
    return colNames[col];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCellEditable(final int row, final int col) {
    return false;
  }

  /**
   * Ajuste da lista de requisies.
   * 
   * @param list a lista
   */
  public void setRequestList(final List<FileTransferRequest> list) {
    this.list = list;
    fireTableDataChanged();
  }

  /**
   * Consulta o valor de list
   * 
   * @return o valor
   */
  public final List<FileTransferRequest> getRequestList() {
    return list;
  }

  /**
   * Construtor.
   * 
   * @param colNames texto das colunas.
   */
  public QueueTableModel(final String[] colNames) {
    this.colNames = colNames;
  }
}
