/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph.utils;

import csbase.client.algorithms.AlgorithmConfiguratorFactory;
import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.utils.CopyAndPasteOperation;
import csbase.client.applications.flowapplication.graph.utils.OperationStatus;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class GraphNodeUpdateOperation {
    private GraphNode node;

    public GraphNodeUpdateOperation(GraphNode node) {
        if (node == null) {
            throw new IllegalArgumentException("O par\u00e2metro node est\u00e1 nulo!");
        }
        this.node = node;
    }

    public static boolean hasNewerVersion(GraphNode node) {
        AlgorithmVersionId nodeVersionId = node.getAlgorithmVersionId();
        AlgorithmInfo algorithm = node.getAlgorithm();
        if (algorithm != null) {
            AlgorithmVersionId latestVersionId;
            AlgorithmVersionInfo currentVersion = algorithm.getVersionInfo((Object)nodeVersionId);
            AlgorithmVersionInfo lastVersion = algorithm.getLastVersion();
            if (lastVersion != null && currentVersion != null && !nodeVersionId.equals((Object)(latestVersionId = lastVersion.getId())) && currentVersion.getType() == lastVersion.getType()) {
                return true;
            }
        }
        return false;
    }

    public boolean hasNewerVersion() {
        return GraphNodeUpdateOperation.hasNewerVersion(this.node);
    }

    public boolean update(boolean askForParameters) {
        return this.updateNode(askForParameters);
    }

    public boolean update() {
        return this.update(true);
    }

    protected boolean updateNode(boolean askForParameters) {
        boolean result = true;
        if (this.hasNewerVersion()) {
            AlgorithmInfo algorithmInfo = this.node.getAlgorithm();
            AlgorithmVersionInfo algorithmVersionInfo = algorithmInfo.getLastVersion();
            AlgorithmVersionInfo currentVersion = algorithmInfo.getVersionInfo((Object)this.node.getAlgorithmVersionId());
            if (algorithmVersionInfo.getType() != currentVersion.getType()) {
                return false;
            }
            Graph graph = this.node.getGraph();
            Window window = graph.getParentWindow();
            AlgorithmConfiguratorView algorithmConfiguratorView = AlgorithmConfiguratorFactory.getInstance().createConfigurationView(window, algorithmVersionInfo, ValidationMode.ALLOW_EMPY_VALUES);
            if (algorithmConfiguratorView == null) {
                return true;
            }
            Point2D.Double nodeLocation = new Point2D.Double(Math.max(0.0, this.node.getX()), Math.max(0.0, this.node.getY()));
            Dimension dimension = new Dimension();
            ((Dimension2D)dimension).setSize(this.node.getWidth(), this.node.getHeight());
            GraphNode newNode = graph.createGraphNode(algorithmConfiguratorView, nodeLocation, dimension, this.node.isBypassed());
            CopyAndPasteOperation operation = new CopyAndPasteOperation(this.node, newNode, true);
            OperationStatus operationStatus = operation.execute();
            if (operationStatus.isConfirmed()) {
                this.node.deattach();
                newNode.setId(this.node.getId());
                if (askForParameters && (operationStatus.hasWarnings() || operationStatus.hasErrors())) {
                    newNode.askForParameterValues();
                }
            } else {
                newNode.deattach();
            }
        }
        return result;
    }
}

