/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import csbase.client.Client;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.DesktopFrame;
import csbase.client.util.ClientUtilities;
import csbase.client.util.ExceptionMessenger;
import csbase.client.util.ThrowableTreeNode;
import csbase.client.util.gui.JMultilineLabel;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public abstract class ExceptionDialog
extends DesktopComponentDialog {
    private static final String _ILLEGAL_WINDOW_EXCEPTION_MESSAGE = "A classe do par\u00e2metro window \u00e9 %s, por\u00e9m deveria ser %s ou %s.";
    protected final Throwable _throwable;
    protected String[] additionalInfo;

    protected ExceptionDialog(Window owner, String title, Throwable throwable) {
        this(owner, title, throwable, null);
    }

    protected ExceptionDialog(Window owner, String title, Throwable throwable, String[] additionalInfo) {
        super(owner, title);
        this._throwable = throwable;
        this.additionalInfo = additionalInfo;
        this.setWindowClosingMethod();
    }

    private void setWindowClosingMethod() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExceptionDialog.this.close();
            }
        });
    }

    public static ExceptionDialog createDialog(Window window, String title, Throwable throwable) {
        return ExceptionDialog.createDialog(window, title, throwable, (String[])null);
    }

    public static ExceptionDialog createDialog(Window window, String title, Throwable throwable, String message) {
        return ExceptionDialog.createDialog(window, title, throwable, message, null);
    }

    public static ExceptionDialog createDialog(Window window, String title, Throwable throwable, String[] additionalInfo) {
        return new DetailedExceptionDialog(window, title, throwable, additionalInfo);
    }

    public static ExceptionDialog createDialog(Window window, String title, Throwable throwable, String message, String[] additionalInfo) {
        return new SimpleExceptionDialog(window, title, throwable, message, additionalInfo);
    }

    protected abstract String getComments();

    protected abstract void setComments(String var1);

    final class DetailThrowableAction
    extends CloseAction {
        protected DetailThrowableAction(ExceptionDialog owner) {
            super(owner, LNG.get((String)"UTIL_ERROR_DETAILS"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ExceptionDialog dialog = ExceptionDialog.createDialog((Window)this.owner, this.owner.getTitle(), this.owner._throwable, this.owner.additionalInfo);
            dialog.setVisible(true);
        }
    }

    final class MailAction
    extends CloseAction {
        protected MailAction(ExceptionDialog owner) {
            super(owner, LNG.get((String)"UTIL_SEND"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String comments;
            Throwable throwable;
            ExceptionMessenger instance = ExceptionMessenger.getInstance();
            boolean sent = instance.send(throwable = this.owner._throwable, comments = this.owner.getComments(), this.owner.additionalInfo);
            if (sent) {
                boolean INFO = true;
                String sentMsg = LNG.get((String)"UTIL_SENT");
                JOptionPane.showMessageDialog(this.owner, sentMsg, "", 1);
                super.actionPerformed(e);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        protected ExceptionDialog owner;

        protected CloseAction(ExceptionDialog owner) {
            this(owner, LNG.get((String)"UTIL_CLOSE"));
        }

        protected CloseAction(ExceptionDialog owner, String text) {
            super(text);
            this.owner = owner;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.owner.close();
        }
    }

    private static final class SimpleExceptionDialog
    extends ExceptionDialog {
        private JTextArea _commentTextArea;

        public SimpleExceptionDialog(Window owner, String title, Throwable throwable, String message, String[] additionalInfo) {
            super(owner, title, throwable, additionalInfo);
            this.buildGui(message);
        }

        @Override
        protected String getComments() {
            return this._commentTextArea.getText();
        }

        @Override
        protected void setComments(String comments) {
            if (null == comments) {
                this._commentTextArea.setText("");
            } else {
                this._commentTextArea.setText(comments);
            }
        }

        private void buildGui(String message) {
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.makeIconPanel(), "West");
            this.getContentPane().add((Component)this.makeMainPanel(message), "Center");
            this.pack();
            this.center();
        }

        private JPanel makeIconPanel() {
            JPanel panel = new JPanel();
            panel.add(new JLabel(UIManager.getIcon("OptionPane.errorIcon")));
            return panel;
        }

        private JPanel makeMainPanel(String message) {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(12, 12, 11, 11);
            c.anchor = 10;
            c.weightx = 1.0;
            c.weighty = 1.0;
            mainPanel.add((Component)this.makeInfoPanel(message), c);
            c.gridy = 1;
            c.anchor = 14;
            c.insets = new Insets(17, 12, 11, 11);
            mainPanel.add((Component)this.makeButtonsPanel(), c);
            return mainPanel;
        }

        private JPanel makeInfoPanel(String message) {
            JComponent label;
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 2;
            if (message == null || message.isEmpty() || message.startsWith("<html>")) {
                label = new JLabel(message);
                panel.add((Component)label, c);
            } else {
                label = new JMultilineLabel();
                ((JMultilineLabel)label).setMaxWidth(550);
                ((JMultilineLabel)label).setJustified(false);
                ((JMultilineLabel)label).setText(message);
                panel.add((Component)label, c);
            }
            c.gridy = 1;
            c.insets = new Insets(12, 0, 0, 0);
            JLabel jwhere = new JLabel(LNG.get((String)"UTIL_EXECUTION_ERROR"));
            panel.add((Component)jwhere, c);
            c.gridy = 2;
            c.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)new JLabel(LNG.get((String)"UTIL_CONTACT_ERROR")), c);
            c.gridy = 3;
            c.insets = new Insets(12, 0, 0, 0);
            panel.add((Component)new JLabel(LNG.get((String)"UTIL_COMMENT")), c);
            c.gridy = 4;
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 1;
            this._commentTextArea = new JTextArea("", 5, 30);
            panel.add((Component)new JScrollPane(this._commentTextArea), c);
            return panel;
        }

        private JPanel makeButtonsPanel() {
            JPanel panel = new JPanel();
            JButton sendButton = new JButton(new MailAction(this));
            JButton detailButton = new JButton(new DetailThrowableAction(this));
            JButton closeButton = new JButton(new CloseAction(this));
            ClientUtilities.adjustEqualSizes(sendButton, detailButton, closeButton);
            panel.add(sendButton);
            panel.add(detailButton);
            panel.add(closeButton);
            return panel;
        }
    }

    private static final class DetailedExceptionDialog
    extends ExceptionDialog {
        private static final int _MESSAGE_COLUMNS = 80;
        private static final int _MESSAGE_ROWS = 4;
        private static final int _STACK_TRACE_COLUMNS = 80;
        private static final int _STACK_TRACE_ROWS = 14;
        private static final int _COMMENT_COLUMNS = 80;
        private static final int _COMMENT_ROWS = 4;
        private static final int _TROUBLE_TREE_WIDTH = 800;
        private static final int _TROUBLE_TREE_HEIGHT = 100;
        private JTextArea _messageTextArea;
        private JTextArea _stackTraceTextArea;
        protected JTextArea _commentTextArea;
        private JTree _throwableTree;

        public DetailedExceptionDialog(Window owner, String title, Throwable throwable, String[] additionalInfo) {
            super(owner, title, throwable, additionalInfo);
            this.createComponents();
        }

        @Override
        protected String getComments() {
            return this._commentTextArea.getText();
        }

        @Override
        protected void setComments(String comments) {
            if (null == comments) {
                this._commentTextArea.setText("");
            } else {
                this._commentTextArea.setText(comments);
            }
        }

        private void createComponents() {
            Color inactiveColor = UIManager.getDefaults().getColor("TextField.inactiveBackground");
            JLabel troubleTreeLabel = new JLabel(LNG.get((String)"UTIL_EXCEPTION_TREE"));
            this._throwableTree = new JTree(new ThrowableTreeNode(this._throwable));
            this._throwableTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DetailedExceptionDialog.this.updateFields();
                }
            });
            this._throwableTree.getSelectionModel().setSelectionMode(1);
            JScrollPane scrollTroubleTree = new JScrollPane(this._throwableTree);
            scrollTroubleTree.setPreferredSize(new Dimension(800, 100));
            JLabel messageLabel = new JLabel(LNG.get((String)"UTIL_EXCEPTION_MESSAGE"));
            this._messageTextArea = new JTextArea(this._throwable.getLocalizedMessage());
            this._messageTextArea.setColumns(80);
            this._messageTextArea.setRows(4);
            this._messageTextArea.setEditable(false);
            this._messageTextArea.setBackground(inactiveColor);
            JLabel stackTraceLabel = new JLabel(LNG.get((String)"UTIL_STACK_TRACE"));
            this._stackTraceTextArea = new JTextArea(this.getStackTraceText(this._throwable.getStackTrace()));
            this._stackTraceTextArea.setColumns(80);
            this._stackTraceTextArea.setRows(14);
            this._stackTraceTextArea.setEditable(false);
            this._stackTraceTextArea.setBackground(inactiveColor);
            JLabel commentLabel = new JLabel(LNG.get((String)"UTIL_COMMENT"));
            this._commentTextArea = new JTextArea();
            this._commentTextArea.setColumns(80);
            this._commentTextArea.setRows(4);
            JPanel buttonsPanel = this.createButtonPanel();
            this.setLayout(new GridBagLayout());
            JScrollPane msgScrollPane = new JScrollPane(this._messageTextArea);
            JScrollPane stackTraceScroll = new JScrollPane(this._stackTraceTextArea);
            JScrollPane commentScrollPane = new JScrollPane(this._commentTextArea);
            Insets li = new Insets(5, 6, 0, 10);
            Insets fi = new Insets(3, 10, 5, 10);
            JLabel label = new JLabel(LNG.get((String)"UTIL_ADDITIONAL_INFO"));
            int y = 0;
            int rows = this.additionalInfo == null || this.additionalInfo.length == 0 ? 3 : Math.min(3 + this.additionalInfo.length, 4);
            JTextArea additionalInfoTextArea = new JTextArea(rows, 80);
            additionalInfoTextArea.setEditable(false);
            additionalInfoTextArea.setBackground(inactiveColor);
            JScrollPane scrollPane = new JScrollPane(additionalInfoTextArea);
            additionalInfoTextArea.setText(this.createAdditionalInfoText());
            this.add((Component)label, new GBC(0, y++).west().insets(li));
            this.add((Component)scrollPane, new GBC(0, y++).both().insets(fi));
            this.add((Component)troubleTreeLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)scrollTroubleTree, new GBC(0, y++).both().insets(fi));
            this.add((Component)messageLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)msgScrollPane, new GBC(0, y++).both().insets(fi));
            this.add((Component)stackTraceLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)stackTraceScroll, new GBC(0, y++).both().insets(fi));
            this.add((Component)commentLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)commentScrollPane, new GBC(0, y++).both().insets(fi));
            this.add((Component)buttonsPanel, new GBC(0, y++).center().insets(7));
            this.pack();
            this.center();
        }

        private String createAdditionalInfoText() {
            String version;
            String info = LNG.get((String)"UTIL_ADDITIONAL_INFO_USER");
            info = info + " " + User.getLoggedUser().getLogin();
            info = info + " (" + User.getLoggedUser().getName() + ")\n";
            if (DesktopFrame.getInstance() != null) {
                CommonClientProject project = DesktopFrame.getInstance().getProject();
                if (project == null) {
                    info = info + LNG.get((String)"UTIL_ADDITIONAL_INFO_NO_PROJECT");
                } else {
                    info = info + LNG.get((String)"UTIL_ADDITIONAL_INFO_PROJECT");
                    info = info + " " + project.getName();
                }
                info = info + "\n";
            }
            if ((version = Client.getInstance().getVersion()) != null) {
                info = info + LNG.get((String)"UTIL_ADDITIONAL_INFO_VERSION");
                info = info + " " + version;
            }
            if (this.additionalInfo != null && this.additionalInfo.length > 0) {
                for (int i = 0; i < this.additionalInfo.length; ++i) {
                    info = info + "\n" + this.additionalInfo[i];
                }
            }
            return info;
        }

        private JPanel createButtonPanel() {
            JPanel panel = new JPanel();
            JButton sendButton = new JButton(new MailAction(this));
            JButton closeButton = new JButton(new CloseAction(this));
            ClientUtilities.adjustEqualSizes(sendButton, closeButton);
            panel.add(sendButton);
            panel.add(closeButton);
            return panel;
        }

        private void updateFields() {
            ThrowableTreeNode node = (ThrowableTreeNode)this._throwableTree.getSelectionPath().getLastPathComponent();
            if (node == null) {
                node = (ThrowableTreeNode)this._throwableTree.getModel().getRoot();
            }
            this._messageTextArea.setText(node.getThrowable().getLocalizedMessage());
            this._stackTraceTextArea.setText(this.getStackTraceText(node.getThrowable().getStackTrace()));
        }

        private String getStackTraceText(StackTraceElement[] stackTrace) {
            String text = "";
            for (int i = 0; i < stackTrace.length; ++i) {
                text = text + stackTrace[i] + "\n";
            }
            return text;
        }
    }
}

