/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui;

import java.awt.Component;
import java.awt.Dimension;

public class ComponentUtilities {
    public static Dimension getMaxPreferredSize(Component ... components) {
        double width = 0.0;
        double height = 0.0;
        for (Component aComponent : components) {
            Dimension preferredSize = aComponent.getPreferredSize();
            width = Math.max(width, preferredSize.getWidth());
            height = Math.max(height, preferredSize.getHeight());
        }
        return new Dimension((int)width, (int)height);
    }

    public static void setMaxPreferredSize(Component ... components) {
        Dimension preferredSize = ComponentUtilities.getMaxPreferredSize(components);
        for (Component aComponent : components) {
            aComponent.setPreferredSize(preferredSize);
        }
    }

    public static void setMaxPreferredWidth(Component ... components) {
        Dimension maxPreferredSize = ComponentUtilities.getMaxPreferredSize(components);
        for (Component aComponent : components) {
            Dimension preferredSize = aComponent.getPreferredSize();
            preferredSize.width = maxPreferredSize.width;
            aComponent.setPreferredSize(preferredSize);
        }
    }

    public static void setMaxPreferredHeight(Component ... components) {
        Dimension maxPreferredSize = ComponentUtilities.getMaxPreferredSize(components);
        for (Component aComponent : components) {
            Dimension preferredSize = aComponent.getPreferredSize();
            preferredSize.height = maxPreferredSize.height;
            aComponent.setPreferredSize(preferredSize);
        }
    }
}

