package csbase.client.applicationmanager;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.desktop.DesktopFrame;

/**
 * Ao interna de disparo de aplicativo.
 * 
 * @author Tecgraf/PUC-Rio
 */
final public class ClearApplicationCacheAction extends AbstractAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent ae) {
    if (!isEnabled()) {
      final String err = "Action perform called and it is inactive!";
      throw new RuntimeException(err);
    }
    final ApplicationManager appManager = ApplicationManager.getInstance();
    try {
      boolean doClear = true;
      if (appManager.hasRunningApplications()) {
        String title = LNG.get("application.manager.warning.title.clear.cache");
        String question = LNG.get("application.manager.warning.clear.cache");
        DesktopFrame frame = DesktopFrame.getInstance();
        int result =
          StandardDialogs.showYesNoDialog(frame.getDesktopFrame(), title,
            question);
        if (result == StandardDialogs.NO_OPTION) {
          doClear = false;
        }
      }
      if (doClear) {
        ApplicationCache.clearCache();
      }
    }
    catch (ApplicationException e) {
      throw new RuntimeException(e);
    }
  }

  /**
   * Construtor.
   */
  public ClearApplicationCacheAction() {
    String actionName = LNG.get("application.manager.action.clear.cache");
    putValue(Action.NAME, actionName);
  }
}
