package csbase.client.applications.algorithmsmanager.report.implementations;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.algorithmsmanager.report.core.AbstractTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Teste para avaliar se existe arquivo de documentao para cada verso dos
 * algoritmos
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class TestHelpMissing extends AbstractTest<AlgorithmInfo> {

  /**
   * Construtor
   * 
   * @param registeredPlatform Lista de plataformas cadastradas no sistema
   * @param window Janela que disparou o teste
   */
  public TestHelpMissing(Window window) {
    super(window, LNG.get("TestHelpMissing.task.title"), LNG
      .get("TestHelpMissing.task.message"));
  }

  /** {@inheritDoc} */
  @Override
  public List<IResultMessage<AlgorithmInfo>> doTest(AlgorithmInfo algorithmInfo) {

    List<IResultMessage<AlgorithmInfo>> result = new ArrayList<>();
    List<AlgorithmVersionInfo> versions = algorithmInfo.getVersions();

    List<AlgorithmVersionInfo> missing =
      versions.stream().filter(
        v -> v.getDocumentation() == null || v.getDocumentation().size() == 0)
        .collect(Collectors.toList());

    if (missing.size() == 0) {
      IResultMessage<AlgorithmInfo> message =
        new ResultMessage<>(algorithmInfo, TestStatus.OK, LNG
          .get("TestHelpMissing.no.missing"));
      result.add(message);
    }
    else if (missing.size() == versions.size()) {
      IResultMessage<AlgorithmInfo> message =
        new ResultMessage<>(algorithmInfo, TestStatus.ERROR, LNG
          .get("TestHelpMissing.all.missing"));
      result.add(message);
    }
    else {
      for (AlgorithmVersionInfo version : missing) {
        IResultMessage<AlgorithmInfo> message =
          new ResultMessage<>(algorithmInfo, TestStatus.WARNING, LNG.get(
            "TestHelpMissing.version.missing", new String[] { version
              .toString() }));
        result.add(message);
      }
    }

    return result;

  }

  /** {@inheritDoc} */
  @Override
  public String getName() {
    return LNG.get("TestHelpMissing.name");
  }

  /** {@inheritDoc} */
  @Override
  public String getDescription() {
    return LNG.get("TestHelpMissing.description");
  }

  /** {@inheritDoc} */
  @Override
  public Class<AlgorithmInfo> getSubjectClass() {
    return AlgorithmInfo.class;
  }

  /** {@inheritDoc} */
  @Override
  public String getSubjectName(AlgorithmInfo subject) {
    return subject.getName();
  }

}
