package csbase.client.applications.serverdiagnostic.properties;

import javax.swing.table.DefaultTableModel;

import tecgraf.javautils.core.lng.LNG;
import csbase.logic.diagnosticservice.PropertyInfo;

/**
 * Modelo da tabela usada para exibir os valores das propriedades de
 * configurao do servidor.
 * 
 * @author Tecgraf PUC-Rio
 */
public class PropertiesTableModel extends DefaultTableModel {

  /** As informaes das propriedades exibidas no painel */
  private PropertyInfo[] propertiesInfo;

  /**
   * Coluna com o nome da propriedade.
   */
  private static final int COLUMN_NAME = 0;
  /**
   * Coluna com o valor corrente da propriedade.
   */
  private static final int COLUMN_CURRENT_VALUE = 1;

  /**
   * Nomes das colunas da tabela.
   */
  private static final String[] COLUMN_NAMES = {
      LNG.get("PropertiesTableModel.header.name"),
      LNG.get("PropertiesTableModel.header.current.value") };

  /**
   * Construtor.
   * 
   * @param propertiesInfo as informaes das propriedades exibidas no painel.
   */
  public PropertiesTableModel(PropertyInfo[] propertiesInfo) {
    this.propertiesInfo = propertiesInfo;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName(int column) {
    return COLUMN_NAMES[column];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnCount() {
    return COLUMN_NAMES.length;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowCount() {
    return propertiesInfo == null ? 0 : propertiesInfo.length;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValueAt(int rowIndex, int columnIndex) {
    switch (columnIndex) {
      case COLUMN_NAME:
        return propertiesInfo[rowIndex].key;

      case COLUMN_CURRENT_VALUE:
        return propertiesInfo[rowIndex].runtimeValue;

      default:
        throw new RuntimeException("coluna invlida: " + columnIndex);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return false;
  }
}
