package csbase.client.desktop;

import csbase.client.applicationmanager.CSDKCacheLocationPreferenceEditor;
import csbase.client.preferences.annotations.Editor;
import csbase.client.preferences.annotations.Hidden;
import csbase.client.preferences.annotations.ReadWrite;
import csbase.client.preferences.annotations.Value;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.editors.FavoriteAlgorithmsEditor;
import csbase.client.preferences.editors.FavoriteApplicationsEditor;
import csbase.client.preferences.editors.NaturalNumberEditor;
import csbase.client.preferences.editors.PreferredAppEditor;
import csbase.client.preferences.types.PVBoolean;
import csbase.client.preferences.types.PVDimension;
import csbase.client.preferences.types.PVInteger;
import csbase.client.preferences.types.PVList;
import csbase.client.preferences.types.PVMap;
import csbase.client.preferences.types.PVString;

/**
 * Enumerao que define as preferncias do desktop.
 * 
 * @author Tecgraf
 */
public enum DesktopPref implements PreferenceDefinition {

  /**
   * Tamanho do desktop.
   */
  @Hidden @Value(type = PVDimension.class, defaultValue = "1024,768") SIZE,

  /**
   * Define se o desktop deve iniciar maximizado.
   */
  @Hidden @Value(type = PVBoolean.class, defaultValue = "false") MAXIMIZED,

  /**
   * Define se  pra exibir os arquivos ocultos na rea de projetos.
   */
  @ReadWrite @Value(type = PVBoolean.class, defaultValue = "false") SHOW_HIDDEN_FILES,

  /**
   * Posio do divisor do painel de aplicaes e de notificaes.
   */
  @Hidden @Editor(NaturalNumberEditor.class) @Value(type = PVInteger.class, defaultValue = "520") DIV_APP_NOTIF,

  /**
   * Posio do divisor da rvore de projetos e da tabela de detalhes.
   */
  @Hidden @Editor(NaturalNumberEditor.class) @Value(type = PVInteger.class, defaultValue = "420") DIV_TREE_TABLE,

  /**
   * Posio do divisor da rvore de projetos e do painel de aplicaes.
   */
  @Hidden @Editor(NaturalNumberEditor.class) @Value(type = PVInteger.class, defaultValue = "300") DIV_TREE_APP,

  /**
   * Flag que define se a rvore de projetos deve ser atualizada
   * automaticamente.
   */
  @ReadWrite @Value(type = PVBoolean.class, defaultValue = "true") AUTO_UPDATE,

  /**
   * Flag que define se deve ser exibido o filtro da rea de projetos.
   */
  @ReadWrite @Value(type = PVBoolean.class, defaultValue = "false") TREE_FILTER,

  /**
   * Flag que define se o estado do desktop (tamanho e posicionamento dos
   * splits) ser salvo ao fechar.
   */
  @ReadWrite @Value(type = PVBoolean.class, defaultValue = "true") SAVE_STATE,

  /**
   * Flag que define se ao abrir o desktop, o ltimo projeto usado pelo usurio
   * deve ser aberto automaticamente.
   */
  @ReadWrite @Value(type = PVBoolean.class, defaultValue = "false") OPEN_LAST_PROJECT,
  
  /**
   * Flag que define se ao abrir o desktop, o TrayIcon deve ser exibido.
   */
  @ReadWrite @Value(type = PVBoolean.class, defaultValue = "true") SHOW_TRAY_ICON,

  /**
   * Lista de identificadores de aplicaes preferenciais.
   */
  @ReadWrite @Editor(FavoriteApplicationsEditor.class) @Value(type = PVList.class, defaultValue = "") FAVORITE_APPLICATIONS,

  /**
   * Mapa que associa um tipo de arquivo a aplicao que a exibe.
   */
  @ReadWrite @Editor(PreferredAppEditor.class) @Value(type = PVMap.class, defaultValue = "") FILE_TYPE_TO_APP,

  /**
   * Lista de identificadores de algoritmos preferenciais.
   */
  @ReadWrite @Editor(FavoriteAlgorithmsEditor.class) @Value(type = PVList.class, defaultValue = "") FAVORITE_ALGORITHMS,

  /**
   * Mapa que associa um tipo de arquivo a aplicao que a exibe.
   */
  @ReadWrite @Value(type = PVBoolean.class, defaultValue = "true") CSDK_CACHE_ENABLED,

  /**
   * Mapa que associa um tipo de arquivo a aplicao que a exibe.
   */
  @ReadWrite @Editor(CSDKCacheLocationPreferenceEditor.class) @Value(type = PVString.class, defaultValue = "JAVA_IO_TMPDIR") CSDK_CACHE_LOCATION;
}
