package csbase.client.util.gui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import csbase.logic.algorithms.AlgorithmConfigurator.ConfiguratorType;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Operador que faz a filtragem de um algoritmo utilizando um
 * {@linkAlgorithmInfo} como parmetro
 *
 * @author Tecgraf/PUC-Rio
 */
public class AlgorithmInfoFilterOperator {

  /** Se deve ignorar caixa alta/baixa */
  boolean ignoreCase;

  /** Se o texto  uma expresso regular */
  boolean useRegex;

  /** Se deve mostrar algorithmo simples */
  boolean showSimple;

  /** Se deve mostrar fluxo */
  boolean showFlow;

  /** Texto para casamento no filtro */
  String text;

  /**
   * Cosnturtor
   * 
   * @param ignoreCase Se deve ignorar caixa alta/baixa
   * @param useRegex Se o texto  uma expresso regular
   * @param showSimple se deve mostrar algorithmo simples
   * @param showFlow Se deve mostrar fluxo
   * @param text Texto para casamento no filtro
   */
  public AlgorithmInfoFilterOperator(boolean ignoreCase, boolean useRegex,
    boolean showSimple, boolean showFlow, String text) {
    super();
    this.ignoreCase = ignoreCase;
    this.useRegex = useRegex;
    this.showSimple = showSimple;
    this.showFlow = showFlow;
    this.text = text;
  }

  /**
   * Aceita ou no o AlgorithmInfo
   * 
   * @param info O AlgorithmInfo
   * @return se aceita ou no
   */
  public boolean accept(AlgorithmInfo info) {
    String name = info.getName();

    if (name == null) {
      name = "";
    }

    ConfiguratorType type = null;
    AlgorithmVersionInfo version = info.getLastVersion();
    if (version != null) {
      type = version.getType();
    }

    if (type == ConfiguratorType.FLOW && !showFlow) {
      return false;
    }
    if (type == ConfiguratorType.SIMPLE && !showSimple) {
      return false;
    }

    if (text == null || text.equals("")) {
      return true;
    }

    if (useRegex) {
      try {
        Pattern pattern = Pattern.compile(text);
        Matcher matcher = pattern.matcher(name);
        return matcher.find();
      }
      catch (PatternSyntaxException e) {
        return false;
      }
    }

    if (ignoreCase) {
      name = name.toUpperCase();
      text = text.toUpperCase();
    }

    return name.contains(text);
  }
}
