/*
 * Decompiled with CFR 0.152.
 */
package csbase.client;

import csbase.client.Client;
import csbase.client.ClientSmartFile;
import csbase.client.ClientSmartFileEvent;
import csbase.client.ClientSmartFileListener;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.logic.ClientOptimizationMode;
import csbase.logic.ClientProjectFile;
import csbase.remote.ClientRemoteLocator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.core.lng.LNG;

public class ClientSmartFileFactory {
    List<ClientSmartFileListener> listeners = new ArrayList<ClientSmartFileListener>();
    private static ClientSmartFileFactory instance = null;
    private ClientOptimizationMode optimizationMode = this.getClientOptimizationMode();
    private String localProjectPath = null;

    public static ClientSmartFileFactory getInstance() {
        return ClientSmartFileFactory.getInstance(null);
    }

    public static ClientSmartFileFactory getInstance(List<ClientSmartFileListener> listeners) {
        if (instance == null) {
            instance = new ClientSmartFileFactory(listeners);
        }
        return instance;
    }

    public ClientSmartFile create(ClientProjectFile cpf) {
        if (cpf == null) {
            return null;
        }
        ClientSmartFile clientSmartFile = new ClientSmartFile(cpf, this.optimizationMode, this.localProjectPath);
        return clientSmartFile;
    }

    public ClientOptimizationMode getClientOptimizationMode() {
        if (this.optimizationMode != null) {
            return this.optimizationMode;
        }
        RemoteTask<ClientOptimizationMode> task = new RemoteTask<ClientOptimizationMode>(){

            protected void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.projectService.getOptimizationMode());
            }
        };
        task.execute(this.getFrame(), this.getTitle(), LNG.get((String)"ClientSmartFile.task.msg"));
        if (task.getStatus()) {
            return (ClientOptimizationMode)task.getResult();
        }
        return null;
    }

    public String getLocalProjectPath() {
        if (this.localProjectPath != null) {
            return this.localProjectPath;
        }
        RemoteTask<String> task = new RemoteTask<String>(){

            protected void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.projectService.getLocalProjectPath());
            }
        };
        task.execute(this.getFrame(), this.getTitle(), LNG.get((String)"ClientSmartFile.task.msg"));
        if (task.getStatus()) {
            return (String)task.getResult();
        }
        return null;
    }

    private JFrame getFrame() {
        return DesktopFrame.getInstance().getDesktopFrame();
    }

    private String getTitle() {
        return this.getFrame().getTitle();
    }

    public ClientSmartFileFactory(List<ClientSmartFileListener> listeners) {
        if (this.optimizationMode == ClientOptimizationMode.NONE) {
            return;
        }
        if (listeners != null) {
            for (ClientSmartFileListener clientSmartFileListener : listeners) {
                this.addListener(clientSmartFileListener);
            }
        }
        if (!Client.getInstance().useClientOptimizationMode()) {
            this.optimizationMode = ClientOptimizationMode.NONE;
            this.localProjectPath = null;
            this.notifyListeners(this.localProjectPath, ClientSmartFileEvent.OptimizationFailCause.CLIENT_PARAMETER_VALUE);
            System.out.println("**** Client executou com par\u00e2metro [client_optimization_mode] = false ****");
            return;
        }
        this.localProjectPath = this.getLocalProjectPath();
        File localProject = new File(this.localProjectPath);
        if (!localProject.exists() || !localProject.isDirectory()) {
            this.notifyListeners(this.localProjectPath, ClientSmartFileEvent.OptimizationFailCause.PROJECT_PATH_NOT_VALID);
            this.optimizationMode = ClientOptimizationMode.NONE;
            System.out.println("**** O path para a \u00e1rea de projetos n\u00e3o \u00e9 v\u00e1lido. Desabilitando otimiza\u00e7\u00e3o. ****");
        } else if (!localProject.canRead()) {
            this.notifyListeners(this.localProjectPath, ClientSmartFileEvent.OptimizationFailCause.CANT_READ_PROJECT_PATH);
            this.optimizationMode = ClientOptimizationMode.NONE;
            System.out.println("**** O path para a \u00e1rea de projetos n\u00e3o permite leitura. Desabilitando otimiza\u00e7\u00e3o. ****");
        } else {
            System.out.println("ClientSmartFileFactory instanciada:\nModo de Otimiza\u00e7\u00e3o: " + this.optimizationMode.name() + "\n\u00c1rea Local de Projeto: " + this.localProjectPath);
        }
    }

    public boolean isOptimizedMode() {
        return this.optimizationMode == ClientOptimizationMode.GLOBAL;
    }

    public void addListener(ClientSmartFileListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ClientSmartFileListener listener) {
        this.listeners.remove(listener);
    }

    void notifyListeners(String localProjectPath, String localFilePath, ClientSmartFileEvent.OptimizationFailCause cause) {
        for (ClientSmartFileListener clientSmartFileListener : this.listeners) {
            clientSmartFileListener.clientOptimizationFileFailed(new ClientSmartFileEvent(localProjectPath, localFilePath, cause));
        }
    }

    void notifyListeners(String localProjectPath, ClientSmartFileEvent.OptimizationFailCause cause) {
        for (ClientSmartFileListener clientSmartFileListener : this.listeners) {
            clientSmartFileListener.clientOptimizationFailed(new ClientSmartFileEvent(localProjectPath, cause));
        }
    }
}

