/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransfer;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.ProjectAdminObserver;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;
import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectUserEvent;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public final class ProjectComboBox
extends JComboBox
implements Observer {
    private Object userId = User.getLoggedUser().getId();

    public ProjectComboBox(Application application) {
        this.loadProjects(application);
        this.setSelectedIndex(-1);
        ProjectAdminObserver.getInstance().addObserver(this);
    }

    public void deleteObserver() {
        ProjectAdminObserver.getInstance().deleteObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(arg instanceof ProjectUserEvent)) {
            return;
        }
        ProjectUserEvent event = (ProjectUserEvent)arg;
        final UserProjectInfo info = new UserProjectInfo((CommonProjectInfo)event.item);
        switch (event.type) {
            case 1: {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProjectComboBox.this.addItem(info);
                    }
                });
                break;
            }
            case 2: {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ProjectComboBox.this.getSelectedItem().equals(info)) {
                            ProjectComboBox.this.setSelectedIndex(-1);
                        }
                        ProjectComboBox.this.removeItem(info);
                    }
                });
            }
        }
    }

    private void loadProjects(Application application) {
        try {
            List projects = null;
            RemoteTask<List<UserProjectInfo>> task = new RemoteTask<List<UserProjectInfo>>(){

                public void performTask() throws Exception {
                    List projects = CommonClientProject.getAllProjectsInfo((Object)ProjectComboBox.this.userId);
                    this.setResult(projects);
                }
            };
            if (!task.execute(application.getApplicationFrame(), application.getName(), application.getString("searching.projects.msg"))) {
                throw task.getError();
            }
            projects = (List)task.getResult();
            Object[] projsArray = projects.toArray(new UserProjectInfo[0]);
            Arrays.sort(projsArray);
            this.setModel(new DefaultComboBoxModel<Object>(projsArray));
        }
        catch (Exception e) {
            ApplicationFrame frame = application.getApplicationFrame();
            StandardErrorDialogs.showErrorDialog((Window)frame, frame.getTitle(), (Throwable)e);
        }
    }
}

