/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.core;

import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.core.ITestResult;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import tecgraf.javautils.gui.GBC;

public class ReportPanel
extends JPanel {
    private String TEST = "T";
    private String STATUS = "S";
    private String SUBJECT = "D";
    private JCheckBox okFilter;
    private JCheckBox warningFilter;
    private JCheckBox errorFilter;
    private JRadioButton colapsedButton;
    private JRadioButton extendedButton;
    private JComboBox<String> firstSorter;
    private JComboBox<String> secondSorter;
    private JTextPane textArea;
    private List<ResultInfo<?>> messages;
    ResourceBundle i18n;

    public ReportPanel(Locale locale) {
        this.i18n = this.createBundle(locale);
        this.messages = new ArrayList();
        this.mountPanel();
    }

    public void updateContent(Map<ITest<?>, ITestResult<?>> map) {
        this.messages = this.convertResult(map);
        this.updateTextArea();
    }

    private void updateTextArea() {
        List<ResultInfo<?>> messageSubList = this.filterData(this.messages, this.okFilter.isSelected(), this.warningFilter.isSelected(), this.errorFilter.isSelected());
        messageSubList = this.sortData(messageSubList, (String)this.firstSorter.getSelectedItem(), (String)this.secondSorter.getSelectedItem());
        if (this.colapsedButton.isSelected()) {
            this.printColapsed(messageSubList, (String)this.firstSorter.getSelectedItem(), (String)this.secondSorter.getSelectedItem());
        } else {
            this.printExpanded(messageSubList, (String)this.firstSorter.getSelectedItem(), (String)this.secondSorter.getSelectedItem());
        }
    }

    private void printExpanded(List<ResultInfo<?>> messageSubList, String firstOrder, String secondOrder) {
        String thirdOrder = this.computeThird(firstOrder, secondOrder);
        StringBuilder builder = new StringBuilder("<html>");
        for (ResultInfo<?> info : messageSubList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(this.TEST, "<i>" + info.test.getName() + "</i>");
            map.put(this.SUBJECT, info.getSubjectName());
            TestStatus status = info.message.getStatus();
            map.put(this.STATUS, this.getFontColor(status) + this.getString(status.toString()) + "</font>");
            builder.append("<strong>");
            builder.append((String)map.get(firstOrder));
            builder.append(" - ");
            builder.append((String)map.get(secondOrder));
            builder.append(" - ");
            builder.append((String)map.get(thirdOrder));
            builder.append("</strong>");
            builder.append(" - ").append(info.message.getMessage());
            builder.append("<br><br>");
        }
        builder.append("</html>");
        this.textArea.setText(builder.toString());
        this.textArea.setCaretPosition(0);
    }

    private void printColapsed(List<ResultInfo<?>> messageSubList, String firstOrder, String secondOrder) {
        String thirdOrder = this.computeThird(firstOrder, secondOrder);
        StringBuilder builder = new StringBuilder("<html>");
        String previousFirst = "";
        String previousSecond = "";
        HashMap<String, String> map = new HashMap<String, String>();
        for (ResultInfo<?> info : messageSubList) {
            map.put(this.TEST, "<i>" + info.test.getName() + "</i>");
            map.put(this.SUBJECT, info.getSubjectName());
            TestStatus status = info.message.getStatus();
            map.put(this.STATUS, this.getFontColor(status) + this.getString(status.toString()) + "</font>");
            String first = (String)map.get(firstOrder);
            String second = (String)map.get(secondOrder);
            String third = (String)map.get(thirdOrder);
            builder.append("<strong>");
            if (!first.equals(previousFirst)) {
                if (!previousFirst.equals("")) {
                    builder.append("<br>");
                }
                builder.append(first).append("<br>");
                previousFirst = first;
                previousSecond = "";
            }
            if (!second.equals(previousSecond)) {
                builder.append("&nbsp;&nbsp;").append(second).append("<br>");
                previousSecond = second;
            }
            builder.append("&nbsp;&nbsp;&nbsp;&nbsp;").append(third);
            builder.append("</strong>");
            builder.append(" - ").append(info.message.getMessage());
            builder.append("<br>");
        }
        builder.append("</html>");
        this.textArea.setText(builder.toString());
        this.textArea.setCaretPosition(0);
    }

    private Object getFontColor(TestStatus status) {
        if (status.equals((Object)TestStatus.OK)) {
            return "<font color=\"green\">";
        }
        if (status.equals((Object)TestStatus.WARNING)) {
            return "<font color=\"orange\">";
        }
        if (status.equals((Object)TestStatus.ERROR)) {
            return "<font color=\"red\">";
        }
        return "<font color=\"black\">";
    }

    private String computeThird(String firstOrder, String secondOrder) {
        if (!this.TEST.equals(firstOrder) && !this.TEST.equals(secondOrder)) {
            return this.TEST;
        }
        if (!this.SUBJECT.equals(firstOrder) && !this.SUBJECT.equals(secondOrder)) {
            return this.SUBJECT;
        }
        return this.STATUS;
    }

    private List<ResultInfo<?>> sortData(List<ResultInfo<?>> list, String firstCriteria, String secondCriteria) {
        HashMap compMap = new HashMap();
        compMap.put(this.TEST, new TestComparator());
        compMap.put(this.SUBJECT, new SubjectComparator());
        compMap.put(this.STATUS, new StatusComparator());
        DoubleLevelComparator comparator = new DoubleLevelComparator((Comparator)compMap.get(firstCriteria), (Comparator)compMap.get(secondCriteria));
        Collections.sort(list, comparator);
        return list;
    }

    private List<ResultInfo<?>> filterData(List<ResultInfo<?>> messagesList, boolean okSelected, boolean warningSelected, boolean errorSelected) {
        return messagesList.stream().filter(r -> r.message.getStatus().equals((Object)TestStatus.OK) && okSelected || r.message.getStatus().equals((Object)TestStatus.WARNING) && warningSelected || r.message.getStatus().equals((Object)TestStatus.ERROR) && errorSelected).collect(Collectors.toList());
    }

    private void mountPanel() {
        this.setLayout(new GridBagLayout());
        this.initializeStatusFilters();
        this.initializeTextStyleButtons();
        this.initializeSortingCombos();
        Font titleFont = new Font("SansSerif", 1, 14);
        JComponent[][] filters = new JComponent[][]{{this.okFilter}, {this.warningFilter}, {this.errorFilter}};
        JPanel filtersPanel = ReportPanel.createGridPanel(filters);
        filtersPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.getString("filters.title"), 0, 1, titleFont));
        JComponent[][] textStyleButtons = new JComponent[][]{{this.colapsedButton}, {this.extendedButton}};
        JPanel textStylePanel = ReportPanel.createGridPanel(textStyleButtons);
        textStylePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.getString("text.style.title"), 0, 1, titleFont));
        JComponent[][] sortingCombos = new JComponent[][]{{new JLabel(this.getString("first.order.label")), this.firstSorter}, {new JLabel(this.getString("second.order.label")), this.secondSorter}};
        JPanel sortingPanel = ReportPanel.createGridPanel(sortingCombos);
        sortingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.getString("sorting.title"), 0, 1, titleFont));
        this.textArea = new JTextPane();
        this.textArea.setFont(new Font("Monospaced", 0, this.textArea.getFont().getSize()));
        this.textArea.setEditable(false);
        this.textArea.setContentType("text/html");
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setMinimumSize(new Dimension(600, 400));
        scrollPane.setPreferredSize(new Dimension(600, 400));
        scrollPane.setVerticalScrollBarPolicy(22);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)filtersPanel, new GBC(0, 0).insets(6, 6, 0, 6).none().northwest());
        leftPanel.add((Component)sortingPanel, new GBC(1, 0).insets(6, 11, 0, 6).none().northwest());
        leftPanel.add((Component)textStylePanel, new GBC(2, 0).insets(6, 11, 0, 6).horizontal().northwest());
        leftPanel.add((Component)new JPanel(), new GBC(3, 0).insets(6, 6, 6, 6).both());
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.add((Component)leftPanel, new GBC(0, 0).horizontal().insets(6, 6, 6, 6));
        this.add((Component)scrollPane, new GBC(0, 1).both().insets(6, 6, 6, 6));
    }

    private void initializeSortingCombos() {
        if (this.firstSorter != null && this.secondSorter != null) {
            return;
        }
        this.TEST = this.getString("sort.by.test");
        this.STATUS = this.getString("sort.by.status");
        this.SUBJECT = this.getString("sort.by.subject");
        final List<String> allSorters = Arrays.asList(this.SUBJECT, this.STATUS, this.TEST);
        this.firstSorter = new JComboBox<String>(new String[]{this.SUBJECT, this.STATUS, this.TEST});
        this.firstSorter.setSelectedIndex(0);
        this.secondSorter = new JComboBox<String>(new String[]{this.STATUS, this.TEST});
        this.firstSorter.setSelectedIndex(0);
        this.firstSorter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String first = (String)ReportPanel.this.firstSorter.getSelectedItem();
                String second = (String)ReportPanel.this.secondSorter.getSelectedItem();
                ArrayList secondSorters = new ArrayList(allSorters);
                secondSorters.remove(first);
                ReportPanel.this.secondSorter.setModel(new DefaultComboBoxModel<String>(secondSorters.toArray(new String[2])));
                if (second.equals(first)) {
                    ReportPanel.this.secondSorter.setSelectedIndex(0);
                } else {
                    ReportPanel.this.secondSorter.setSelectedItem(second);
                }
                ReportPanel.this.updateTextArea();
            }
        });
        this.secondSorter.addActionListener(e -> this.updateTextArea());
    }

    private void initializeTextStyleButtons() {
        if (this.colapsedButton != null && this.extendedButton != null) {
            return;
        }
        this.colapsedButton = new JRadioButton(this.getString("collapsed.button"));
        this.extendedButton = new JRadioButton(this.getString("expanded.button"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.colapsedButton);
        group.add(this.extendedButton);
        this.colapsedButton.setSelected(true);
        this.extendedButton.setSelected(false);
        ActionListener action = e -> this.updateTextArea();
        this.colapsedButton.addActionListener(action);
        this.extendedButton.addActionListener(action);
    }

    private void initializeStatusFilters() {
        if (this.okFilter != null && this.warningFilter != null && this.errorFilter != null) {
            return;
        }
        this.okFilter = new JCheckBox(this.getString("ok.check"));
        this.warningFilter = new JCheckBox(this.getString("warning.check"));
        this.errorFilter = new JCheckBox(this.getString("error.check"));
        ActionListener action = e -> this.updateTextArea();
        this.okFilter.setSelected(false);
        this.warningFilter.setSelected(true);
        this.errorFilter.setSelected(true);
        this.okFilter.addActionListener(action);
        this.warningFilter.addActionListener(action);
        this.errorFilter.addActionListener(action);
    }

    private List<ResultInfo<?>> convertResult(Map<ITest<?>, ITestResult<?>> testMap) {
        ArrayList messages = new ArrayList();
        for (ITest<?> test : testMap.keySet()) {
            ITestResult<?> result = testMap.get(test);
            for (IResultMessage<?> message : result.getMessages()) {
                ResultInfo info = new ResultInfo();
                info.test = test;
                info.message = message;
                messages.add(info);
            }
        }
        return messages;
    }

    private ResourceBundle createBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(this.getClass().getName(), locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    protected String getString(String key) {
        if (this.i18n != null && this.i18n.containsKey(key)) {
            return this.i18n.getString(key);
        }
        return key;
    }

    public static final JPanel createGridPanel(JComponent[][] rows) {
        if (rows == null) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int T = 6;
        int TI = 3;
        int L = 6;
        int R = 6;
        int y = 0;
        for (JComponent[] row : rows) {
            int t = 3;
            if (y == 0) {
                t = 6;
            }
            panel.add((Component)row[0], new GBC(0, y).insets(t, 6, 0, 6).none().west().weights(1.0, 0.0));
            if (row.length > 1) {
                panel.add((Component)row[1], new GBC(1, y).insets(t, 6, 0, 6).horizontal().weightx(100.0).west().weights(1.0, 0.0));
            }
            ++y;
        }
        return panel;
    }

    static class DoubleLevelComparator
    implements Comparator<ResultInfo<?>> {
        private final Comparator<ResultInfo<?>> comp1;
        private final Comparator<ResultInfo<?>> comp2;

        public DoubleLevelComparator(Comparator<ResultInfo<?>> comp1, Comparator<ResultInfo<?>> comp2) {
            this.comp1 = comp1;
            this.comp2 = comp2;
        }

        @Override
        public int compare(ResultInfo<?> o1, ResultInfo<?> o2) {
            int result1 = this.comp1.compare(o1, o2);
            if (result1 == 0) {
                return this.comp2.compare(o1, o2);
            }
            return result1;
        }
    }

    private static class StatusComparator
    implements Comparator<ResultInfo<?>> {
        private StatusComparator() {
        }

        @Override
        public int compare(ResultInfo<?> o1, ResultInfo<?> o2) {
            TestStatus s2;
            TestStatus s1 = o1.message.getStatus();
            if (s1.equals((Object)(s2 = o2.message.getStatus()))) {
                return 0;
            }
            if (s1 == TestStatus.OK) {
                return -1;
            }
            if (s2 == TestStatus.OK) {
                return 1;
            }
            if (s1 == TestStatus.WARNING) {
                return -1;
            }
            if (s2 == TestStatus.WARNING) {
                return 1;
            }
            if (s1 == TestStatus.ERROR) {
                return -1;
            }
            if (s2 == TestStatus.ERROR) {
                return 1;
            }
            return 0;
        }
    }

    private static class SubjectComparator
    implements Comparator<ResultInfo<?>> {
        private SubjectComparator() {
        }

        @Override
        public int compare(ResultInfo<?> o1, ResultInfo<?> o2) {
            String s1 = o1.getSubjectName();
            String s2 = o2.getSubjectName();
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class TestComparator
    implements Comparator<ResultInfo<?>> {
        private TestComparator() {
        }

        @Override
        public int compare(ResultInfo<?> o1, ResultInfo<?> o2) {
            return o1.test.getName().compareToIgnoreCase(o2.test.getName());
        }
    }

    class ResultInfo<T> {
        protected ITest<T> test;
        protected IResultMessage<T> message;

        ResultInfo() {
        }

        String getSubjectName() {
            return this.test.getSubjectName(this.message.getSubject());
        }
    }
}

