/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.implementations;

import csbase.client.applications.Application;
import csbase.client.applications.algorithmsmanager.report.core.AbstractSubjectFactory;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.implementations.AlgorithmInfoSource;
import csbase.client.applications.algorithmsmanager.report.implementations.FlowConfiguratorSource;
import csbase.client.applications.algorithmsmanager.report.implementations.ParameterSource;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import java.util.HashMap;
import java.util.Map;

public class AlgorithmManagerSubjectFactory
extends AbstractSubjectFactory {
    private final Map<Class<?>, Iterable<?>> sources = new HashMap();
    private final Application app;

    public AlgorithmManagerSubjectFactory(Application app) {
        this.app = app;
    }

    private <T> void addSource(Class<T> clazz, Iterable<T> source) {
        this.sources.put(clazz, source);
    }

    @Override
    public <T> Iterable<T> createSubject(ITest<T> test) {
        Class<T> subjectType = test.getSubjectClass();
        Iterable<?> subject = this.sources.get(subjectType);
        if (subject == null) {
            if (subjectType.equals(AlgorithmInfo.class)) {
                this.addSource(AlgorithmInfo.class, new AlgorithmInfoSource(this.app));
            } else if (subjectType.equals(FlowAlgorithmConfigurator.class)) {
                this.addSource(FlowAlgorithmConfigurator.class, new FlowConfiguratorSource(this.app));
            } else if (subjectType.equals(Class.class)) {
                this.addSource(Class.class, new ParameterSource(this.app));
            }
            subject = this.sources.get(subjectType);
        }
        return subject;
    }

    public void reset() {
        this.sources.clear();
        this.callListeners();
    }
}

